/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.util.Iterator;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final String EXCEPTION_MESSAGE_KEY = "message";
    private static final int PAD_LEFT = 0;
    private static final int PAD_RIGHT = 1;

    public static String toExceptionString(Class<?> clazz, Properties props) {
        StringBuffer retBuf = new StringBuffer(clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1));
        String msg = props.getProperty(EXCEPTION_MESSAGE_KEY);
        if (msg != null) {
            retBuf.append("(");
            retBuf.append(msg);
            retBuf.append(")");
            props.remove(EXCEPTION_MESSAGE_KEY);
        }
        retBuf.append(" {");
        retBuf.append(StringUtil.propertiesToString(props));
        retBuf.append("}");
        return retBuf.toString();
    }

    public static String toString(Class<?> clazz, Properties props) {
        return StringUtil.toString(clazz, null, props);
    }

    public static String toString(Class<?> clazz, String qualifier, Properties props) {
        StringBuffer retBuf = new StringBuffer(clazz == null ? "" : clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1));
        if (qualifier != null) {
            retBuf.append("(");
            retBuf.append(qualifier);
            retBuf.append(")");
        }
        retBuf.append(" {");
        retBuf.append(StringUtil.propertiesToString(props));
        retBuf.append("}");
        return retBuf.toString();
    }

    public static String propertiesToString(Properties props) {
        StringBuffer retBuf = new StringBuffer();
        if (props != null) {
            boolean first = true;
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                if (!first) {
                    retBuf.append(", ");
                }
                String label = (String)it.next();
                String value = props.getProperty(label);
                retBuf.append(label);
                retBuf.append(": ");
                retBuf.append(label.toLowerCase().contains("password") ? "******" : value);
                first = false;
            }
        }
        return retBuf.toString();
    }

    public static String truncate(String s, int maxLength) {
        if (s == null) {
            return s;
        }
        if (s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, Math.min(maxLength, s.length()));
    }

    public static String truncateStringWithEllipsis(String s, int maxLength) {
        String sRet = s;
        int n = maxLength = maxLength > 3 ? maxLength : 4;
        if (s.length() > maxLength) {
            StringBuffer sb = new StringBuffer();
            sb.append(s.substring(0, maxLength - 3));
            sb.append("...");
            sRet = sb.toString();
        }
        return sRet;
    }

    public static String padLeft(String in, int minLen) {
        return StringUtil.padLeftRight(in, minLen, 0);
    }

    public static String padRight(String in, int minLen) {
        return StringUtil.padLeftRight(in, minLen, 1);
    }

    private static String padLeftRight(String in, int minLen, int padSide) {
        if (in.length() < minLen) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < minLen - in.length(); ++i) {
                sb.append(" ");
            }
            switch (padSide) {
                case 0: {
                    sb.append(in);
                    break;
                }
                case 1: {
                    sb.insert(0, in);
                    break;
                }
                default: {
                    return in;
                }
            }
            return sb.toString();
        }
        return in;
    }

    public static int getStringUtfByteLength(String str) {
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            char c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    static String getPrintableByte(byte b) {
        if (b >= 33 && b <= 126) {
            return String.valueOf((char)b);
        }
        return ".";
    }

    public static String formatDumpBytes(byte[] data, boolean showdecode, int leftPadding) {
        StringBuilder output = new StringBuilder(data.length * 3);
        StringBuilder cur_line = new StringBuilder();
        StringBuilder cur_ascii = new StringBuilder();
        int lineBytes = 0;
        int ascii_print_offset = 54;
        for (int i = 0; i < data.length; ++i) {
            cur_line.append(String.format("%02x", data[i])).append(" ");
            cur_ascii.append(StringUtil.getPrintableByte(data[i]));
            if (++lineBytes == 8) {
                cur_line.append("   ");
            }
            if (lineBytes != 16 && i != data.length - 1) continue;
            if (leftPadding > 0) {
                output.append(StringUtil.padRight("", leftPadding));
            }
            String bin_data = StringUtil.padRight(cur_line.toString(), 54);
            output.append(bin_data);
            if (showdecode) {
                output.append((CharSequence)cur_ascii);
            }
            output.append("\n");
            cur_line = new StringBuilder();
            cur_ascii = new StringBuilder();
            lineBytes = 0;
        }
        return output.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

