/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPPropertyMap;
import com.solacesystems.jcsmp.impl.JCSMPPropertiesTextMarshaling;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.secure.SecureSessionProperties;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCSMPProperties
extends JCSMPPropertyMap
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String SUPPORTED_MESSAGE_ACK_AUTO = "auto_ack";
    public static final String SUPPORTED_MESSAGE_ACK_CLIENT = "client_ack";
    @SolReserved
    public static final String SUPPORTED_MESSAGE_ACK_CLIENT_WINDOWED = "client_ack_windowed";
    public static final String SUPPORTED_ACK_EVENT_MODE_PER_MSG = "SUPPORTED_ACK_EVENT_MODE_PER_MSG";
    public static final String SUPPORTED_ACK_EVENT_MODE_WINDOWED = "SUPPORTED_ACK_EVENT_MODE_WINDOWED";
    @Deprecated
    public static final String CLIENT_MODE = "client_mode";
    public static final String AUTHENTICATION_SCHEME_BASIC = "AUTHENTICATION_SCHEME_BASIC";
    public static final String AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE = "AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE";
    public static final String AUTHENTICATION_SCHEME_GSS_KRB = "AUTHENTICATION_SCHEME_GSS_KRB";
    @SolReserved
    public static final String CONNECTION_TYPE_BASIC = "CONNECTION_TYPE_BASIC";
    @SolReserved
    public static final String CONNECTION_TYPE_XA = "CONNECTION_TYPE_XA";
    public static final String TRANSPORT_PROTOCOL_PLAIN_TEXT = "PLAIN_TEXT";
    public static final String HOST = "host";
    public static final String SESSION_NAME = "session_name";
    public static final String LOCALHOST = "localhost";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SECURE_PROPS = "secure_props";
    public static final String CLIENT_CHANNEL_PROPERTIES = "client_channel";
    public static final String MESSAGE_ACK_MODE = "message_ack_mode";
    public static final String APPLICATION_DESCRIPTION = "application_description";
    public static final String CLIENT_NAME = "client_name";
    public static final String P2PINBOX_IN_USE = "p2pinbox_in_use";
    public static final String GENERATE_SENDER_ID = "generate_sender_id";
    public static final String GENERATE_SEND_TIMESTAMPS = "generate_send_timestamps";
    public static final String GENERATE_RCV_TIMESTAMPS = "generate_rcv_timestamps";
    public static final String GENERATE_SEQUENCE_NUMBERS = "generate_sequence_numbers";
    public static final String CALCULATE_MESSAGE_EXPIRATION = "calculate_message_expiration";
    public static final String VPN_NAME = "vpn_name";
    public static final String VPN_NAME_IN_USE = "vpn_name_in_use";
    public static final String SUBSCRIBER_LOCAL_PRIORITY = "subscriber_local_priority";
    public static final String SUBSCRIBER_NETWORK_PRIORITY = "subscriber_network_priority";
    public static final String REAPPLY_SUBSCRIPTIONS = "reapply_subscriptions";
    public static final String PUB_MULTI_THREAD = "pub_multi_thread";
    public static final String PUB_USE_INTERMEDIATE_DIRECT_BUF = "pub_use_intermediate_direct_buf";
    public static final String MESSAGE_CALLBACK_ON_REACTOR = "MESSAGE_CALLBACK_ON_REACTOR";
    public static final String IGNORE_DUPLICATE_SUBSCRIPTION_ERROR = "IGNORE_DUPLICATE_SUBSCRIPTION_ERROR";
    public static final String IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR = "IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR";
    public static final String VIRTUAL_ROUTER_NAME = "VIRTUAL_ROUTER_NAME";
    public static final String NO_LOCAL = "NO_LOCAL";
    public static final String ACK_EVENT_MODE = "ACK_EVENT_MODE";
    public static final String SSL_EXCLUDED_PROTOCOLS = "SSL_EXCLUDED_PROTOCOLS";
    public static final String SSL_VALIDATE_CERTIFICATE = "SSL_VALIDATE_CERTIFICATE";
    public static final String SSL_VALIDATE_CERTIFICATE_DATE = "SSL_VALIDATE_CERTIFICATE_DATE";
    public static final String SSL_CIPHER_SUITES = "SSL_CIPHER_SUITES";
    public static final String SSL_TRUST_STORE = "SSL_TRUST_STORE";
    public static final String SSL_TRUST_STORE_PASSWORD = "SSL_TRUST_STORE_PASSWORD";
    public static final String SSL_TRUST_STORE_FORMAT = "SSL_TRUST_STORE_FORMAT";
    public static final String SSL_TRUSTED_COMMON_NAME_LIST = "SSL_TRUSTED_COMMON_NAME_LIST";
    public static final String SSL_KEY_STORE = "SSL_KEY_STORE";
    public static final String SSL_KEY_STORE_PASSWORD = "SSL_KEY_STORE_PASSWORD";
    public static final String SSL_KEY_STORE_FORMAT = "SSL_KEY_STORE_FORMAT";
    public static final String SSL_KEY_STORE_NORMALIZED_FORMAT = "SSL_KEY_STORE_NORMALIZED_FORMAT";
    public static final String SSL_PRIVATE_KEY_ALIAS = "SSL_PRIVATE_KEY_ALIAS";
    public static final String SSL_PRIVATE_KEY_PASSWORD = "SSL_PRIVATE_KEY_PASSWORD";
    public static final String KRB_SERVICE_NAME = "KRB_SERVICE_NAME";
    @Deprecated
    public static final String SSL_PROTOCOL = "SSL_PROTOCOL";
    public static final String AUTHENTICATION_SCHEME = "AUTHENTICATION_SCHEME";
    public static final String SSL_CONNECTION_DOWNGRADE_TO = "SSL_CONNECTION_DOWNGRADE_TO";
    public static final String GD_RECONNECT_FAIL_ACTION = "gd_reconnect_fail_action";
    public static final String GD_RECONNECT_FAIL_ACTION_AUTO_RETRY = "gd_reconnect_fail_action_auto_retry";
    public static final String GD_RECONNECT_FAIL_ACTION_DISCONNECT = "gd_reconnect_fail_action_disconnect";
    @SolReserved
    public static final String KRB_MUTUAL_AUTHENTICATION = "KRB_MUTUAL_AUTHENTICATION";
    @SolReserved
    public static final String P2PTOPICDESCRIPTION = "P2PTOPICDESCRIPTION";
    @SolReserved
    public static final String TOPIC_DISPATCH = "topic_dispatch";
    @SolReserved
    public static final String TOPIC_DISPATCH_OPTIMIZE_DIRECT = "topic_dispatch_optimize_direct";
    @SolReserved
    public static final String CLIENT_INFO_PROVIDER = "client_info_provider";
    @SolReserved
    public static final String AD_PUB_ROUTER_WINDOWED_ACK = "ad_pub_router_windowed_ack";
    @SolReserved
    public static final String CONNECTION_TYPE = "connection_type";
    public static final String CONTROL_CHANNEL_PROPERTIES = "control_channel";
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES = "publisher_data_channel";
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES = "subscriber_data_channel";
    public static final String SUB_ACK_WINDOW_SIZE = "sub_ack_window_size";
    public static final String PUB_ACK_WINDOW_SIZE = "pub_ack_window_size";
    public static final String SUB_ACK_TIME = "sub_ack_time";
    public static final String PUB_ACK_TIME = "pub_ack_time";
    public static final String SUB_ACK_WINDOW_THRESHOLD = "sub_ack_window_threshold";
    @Deprecated
    public static final String MAX_RESENDS = "max_resends";
    @SolReserved
    public static final String LARGE_MESSAGING = "large_messaging";
    @SolReserved
    public static final String LARGE_MESSAGING_SEGMENT_SIZE = "large_message_segment_size";
    @SolReserved
    public static final String LARGE_MESSAGING_CONSUME_TIMEOUT = "large_message_consume_timeout";
    @SolReserved
    public static final String LARGE_MESSAGING_MAX_MSG_SIZE = "large_message_max_size";
    public static final String MAX_AD_FLOWCTRL_RETRIES = "max_ad_flowctrl_retries";
    public static final String DEFAULT_SESSION_NAME = "JCSMPSession";
    public static final String KRB_SERVICE_DEFAULT = "solace";

    private static HashMap<String, Object> getDefaultProperties() {
        HashMap<String, Object> _defaultProperties = new HashMap<String, Object>();
        _defaultProperties.clear();
        _defaultProperties.put(SESSION_NAME, DEFAULT_SESSION_NAME);
        _defaultProperties.put(LOCALHOST, "");
        _defaultProperties.put(HOST, "");
        _defaultProperties.put(USERNAME, "");
        _defaultProperties.put(PASSWORD, "");
        _defaultProperties.put(MESSAGE_ACK_MODE, SUPPORTED_MESSAGE_ACK_AUTO);
        _defaultProperties.put(SUB_ACK_WINDOW_SIZE, 255);
        _defaultProperties.put(SUB_ACK_TIME, 1000);
        _defaultProperties.put(SUB_ACK_WINDOW_THRESHOLD, 60);
        _defaultProperties.put(PUB_ACK_WINDOW_SIZE, 1);
        _defaultProperties.put(PUB_ACK_TIME, 2000);
        _defaultProperties.put(MAX_RESENDS, 30);
        _defaultProperties.put(MAX_AD_FLOWCTRL_RETRIES, 15);
        _defaultProperties.put(CLIENT_MODE, false);
        _defaultProperties.put(APPLICATION_DESCRIPTION, "");
        _defaultProperties.put(GENERATE_SENDER_ID, Boolean.FALSE);
        _defaultProperties.put(GENERATE_SEND_TIMESTAMPS, Boolean.FALSE);
        _defaultProperties.put(GENERATE_RCV_TIMESTAMPS, Boolean.FALSE);
        _defaultProperties.put(GENERATE_SEQUENCE_NUMBERS, Boolean.FALSE);
        _defaultProperties.put(CALCULATE_MESSAGE_EXPIRATION, Boolean.FALSE);
        _defaultProperties.put(VPN_NAME, "");
        _defaultProperties.put(VPN_NAME_IN_USE, "");
        _defaultProperties.put(VIRTUAL_ROUTER_NAME, "");
        _defaultProperties.put(SUBSCRIBER_LOCAL_PRIORITY, 1);
        _defaultProperties.put(SUBSCRIBER_NETWORK_PRIORITY, 1);
        _defaultProperties.put(REAPPLY_SUBSCRIPTIONS, Boolean.FALSE);
        _defaultProperties.put(TOPIC_DISPATCH, Boolean.FALSE);
        _defaultProperties.put(TOPIC_DISPATCH_OPTIMIZE_DIRECT, Boolean.FALSE);
        _defaultProperties.put(PUB_MULTI_THREAD, Boolean.TRUE);
        _defaultProperties.put(PUB_USE_INTERMEDIATE_DIRECT_BUF, Boolean.TRUE);
        _defaultProperties.put(MESSAGE_CALLBACK_ON_REACTOR, Boolean.FALSE);
        _defaultProperties.put(IGNORE_DUPLICATE_SUBSCRIPTION_ERROR, Boolean.FALSE);
        _defaultProperties.put(IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR, Boolean.FALSE);
        _defaultProperties.put(NO_LOCAL, Boolean.FALSE);
        _defaultProperties.put(AD_PUB_ROUTER_WINDOWED_ACK, Boolean.TRUE);
        _defaultProperties.put(ACK_EVENT_MODE, SUPPORTED_ACK_EVENT_MODE_PER_MSG);
        _defaultProperties.put(SSL_PROTOCOL, "SSLv3,TLSv1,TLSv1.1,TLSv1.2");
        _defaultProperties.put(SSL_EXCLUDED_PROTOCOLS, "");
        _defaultProperties.put(SSL_VALIDATE_CERTIFICATE, true);
        _defaultProperties.put(SSL_VALIDATE_CERTIFICATE_DATE, true);
        _defaultProperties.put(SSL_CIPHER_SUITES, SecureProperties.SupportedJSSECipherNamesString);
        _defaultProperties.put(SSL_TRUST_STORE, "");
        _defaultProperties.put(SSL_TRUST_STORE_FORMAT, KeyStore.getDefaultType());
        _defaultProperties.put(SSL_KEY_STORE, "");
        _defaultProperties.put(SSL_KEY_STORE_FORMAT, KeyStore.getDefaultType());
        _defaultProperties.put(SSL_KEY_STORE_NORMALIZED_FORMAT, "");
        _defaultProperties.put(SSL_TRUSTED_COMMON_NAME_LIST, "");
        _defaultProperties.put(AUTHENTICATION_SCHEME, AUTHENTICATION_SCHEME_BASIC);
        _defaultProperties.put(KRB_MUTUAL_AUTHENTICATION, Boolean.TRUE);
        _defaultProperties.put(KRB_SERVICE_NAME, KRB_SERVICE_DEFAULT);
        _defaultProperties.put(LARGE_MESSAGING, Boolean.FALSE);
        _defaultProperties.put(LARGE_MESSAGING_SEGMENT_SIZE, 0x900000);
        _defaultProperties.put(LARGE_MESSAGING_CONSUME_TIMEOUT, 100000);
        _defaultProperties.put(LARGE_MESSAGING_MAX_MSG_SIZE, 0xC800000);
        _defaultProperties.put(CONNECTION_TYPE, CONNECTION_TYPE_BASIC);
        _defaultProperties.put(SSL_CONNECTION_DOWNGRADE_TO, "");
        _defaultProperties.put(GD_RECONNECT_FAIL_ACTION, GD_RECONNECT_FAIL_ACTION_AUTO_RETRY);
        JCSMPChannelProperties cprops = new JCSMPChannelProperties();
        cprops.setReadTimeoutInMillis(120000);
        _defaultProperties.put(CONTROL_CHANNEL_PROPERTIES, cprops);
        JCSMPChannelProperties pprops = new JCSMPChannelProperties();
        _defaultProperties.put(PUBLISHER_DATA_CHANNEL_PROPERTIES, pprops);
        JCSMPChannelProperties sprops = new JCSMPChannelProperties();
        _defaultProperties.put(SUBSCRIBER_DATA_CHANNEL_PROPERTIES, sprops);
        JCSMPChannelProperties clientprops = new JCSMPChannelProperties();
        _defaultProperties.put(CLIENT_CHANNEL_PROPERTIES, clientprops);
        return _defaultProperties;
    }

    public JCSMPProperties() {
        HashMap<String, Object> defaults = JCSMPProperties.getDefaultProperties();
        this._properties.putAll(defaults);
        this._isUsernameSet = false;
        this.getSystemPropertyValues();
    }

    private void getSystemPropertyValues() {
        String reconnectAction;
        String envKeyStorePwd;
        String envKeyStoreNormalizedFmt;
        String envKeyStoreFmt;
        String envKeyStore;
        String envTrustStoreFmt;
        String envTrustStorePwd;
        String envTrustStore = System.getProperty("javax.net.ssl.trustStore");
        if (envTrustStore != null) {
            this._properties.put(SSL_TRUST_STORE, envTrustStore);
        }
        if ((envTrustStorePwd = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
            this._properties.put(SSL_TRUST_STORE_PASSWORD, envTrustStorePwd);
        }
        if ((envTrustStoreFmt = System.getProperty("javax.net.ssl.trustStoreType")) != null) {
            this._properties.put(SSL_TRUST_STORE_FORMAT, envTrustStoreFmt);
        }
        if ((envKeyStore = System.getProperty("javax.net.ssl.keyStore")) != null) {
            this._properties.put(SSL_KEY_STORE, envKeyStore);
        }
        if ((envKeyStoreFmt = System.getProperty("javax.net.ssl.keyStoreType")) != null) {
            this._properties.put(SSL_KEY_STORE_FORMAT, envKeyStoreFmt);
        }
        if ((envKeyStoreNormalizedFmt = System.getProperty("javax.net.ssl.keyStoreNormalizedType")) != null) {
            this._properties.put(SSL_KEY_STORE_NORMALIZED_FORMAT, envKeyStoreNormalizedFmt);
        }
        if ((envKeyStorePwd = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
            this._properties.put(SSL_KEY_STORE_PASSWORD, envKeyStorePwd);
        }
        if ((reconnectAction = System.getProperty(GD_RECONNECT_FAIL_ACTION)) != null) {
            this._properties.put(GD_RECONNECT_FAIL_ACTION, reconnectAction);
        }
    }

    public JCSMPProperties(String host, int port, String username, String password, SecureSessionProperties secureProps) {
        this();
        this.setProperty(HOST, host);
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.getProperty(CONTROL_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        channelProperties = (JCSMPChannelProperties)this.getProperty(PUBLISHER_DATA_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        channelProperties = (JCSMPChannelProperties)this.getProperty(SUBSCRIBER_DATA_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        channelProperties = (JCSMPChannelProperties)this.getProperty(CLIENT_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        this.setProperty(USERNAME, username);
        this.setProperty(PASSWORD, password);
        if (secureProps != null) {
            this.setProperty(SECURE_PROPS, secureProps);
        }
    }

    public String toString() {
        Iterator iter = this._properties.keySet().iterator();
        StringBuffer result = new StringBuffer("\n");
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.equals(PASSWORD) || key.equals(SSL_TRUST_STORE_PASSWORD) || key.equals(SSL_KEY_STORE_PASSWORD) || key.equals(SSL_PRIVATE_KEY_PASSWORD)) continue;
            if (first) {
                result.append(" {").append(key).append(", ").append(this._properties.get(key)).append("}");
                first = false;
                continue;
            }
            result.append(",\n ").append("{").append(key).append(", ").append(this._properties.get(key)).append(" }");
        }
        return result.toString();
    }

    public Properties toProperties() {
        return JCSMPPropertiesTextMarshaling.toProperties(this);
    }

    public static JCSMPProperties fromProperties(Properties p) {
        return JCSMPPropertiesTextMarshaling.fromProperties(p);
    }

    @SolReserved
    public boolean isUsernameSet() {
        return this._isUsernameSet;
    }
}

