/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.Subscription;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionCache {
    private HashMap<Endpoint, Set<SubscriptionCacheEntry>> sset = new HashMap();

    public synchronized void add(Endpoint e, Subscription s) {
        SubscriptionCacheEntry sce;
        Set<SubscriptionCacheEntry> subs = this.sset.get(e);
        if (subs == null) {
            subs = new HashSet<SubscriptionCacheEntry>();
            this.sset.put(e, subs);
        }
        if (!subs.contains(sce = new SubscriptionCacheEntry(e, s))) {
            subs.add(sce);
        }
    }

    public synchronized void add(Endpoint e, Collection<Subscription> s) {
        for (Subscription sub : s) {
            this.add(e, sub);
        }
    }

    public synchronized void remove(Endpoint e) {
        this.sset.remove(e);
    }

    public synchronized void remove(Endpoint e, Subscription s) {
        Set<SubscriptionCacheEntry> subs = this.sset.get(e);
        if (subs != null) {
            subs.remove(new SubscriptionCacheEntry(e, s));
            if (subs.size() == 0) {
                this.sset.remove(e);
            }
        }
    }

    public synchronized void remove(Endpoint e, Collection<Subscription> s) {
        for (Subscription sub : s) {
            this.remove(e, sub);
        }
    }

    public synchronized void clear() {
        this.sset.clear();
    }

    public synchronized void replace(Set<Subscription> s) {
        this.sset.clear();
        this.add(null, s);
    }

    public synchronized Set<SubscriptionCacheEntry> getShallowCopy() {
        HashSet<SubscriptionCacheEntry> copy = new HashSet<SubscriptionCacheEntry>();
        Iterator<Set<SubscriptionCacheEntry>> it = this.sset.values().iterator();
        while (it.hasNext()) {
            copy.addAll((Collection<SubscriptionCacheEntry>)it.next());
        }
        return copy;
    }

    public synchronized Set<Subscription> getSubscriptionShallowCopy() {
        HashSet<Subscription> copy = new HashSet<Subscription>();
        Set<SubscriptionCacheEntry> subs = this.sset.get(null);
        if (subs != null) {
            Iterator<SubscriptionCacheEntry> it = subs.iterator();
            while (it.hasNext()) {
                copy.add(it.next().subscription);
            }
        }
        return copy;
    }

    public synchronized String toString() {
        return this.sset.toString();
    }

    public static class SubscriptionCacheEntry {
        public Endpoint endpoint;
        public Subscription subscription;

        public SubscriptionCacheEntry(Endpoint endpoint, Subscription subscription) {
            this.endpoint = endpoint;
            this.subscription = subscription;
        }

        public int hashCode() {
            return this.subscription.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SubscriptionCacheEntry) {
                SubscriptionCacheEntry other = (SubscriptionCacheEntry)obj;
                if (!this.subscription.equals(other.subscription)) {
                    return false;
                }
                if (this.endpoint == null) {
                    return other.endpoint == null;
                }
                if (other.endpoint == null) {
                    return false;
                }
                return this.endpoint.equals(other.endpoint);
            }
            return false;
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder("[");
            if (this.endpoint != null) {
                bldr.append(this.endpoint);
                bldr.append(",");
            }
            bldr.append(this.subscription);
            bldr.append("]");
            return bldr.toString();
        }
    }
}

