/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.combinatorics.internal;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class CombinationUtil {
    private CombinationUtil() {
    }

    @SafeVarargs
    public static <T> Stream<List<T>> of(T ... items) {
        return IntStream.rangeClosed(1, items.length).mapToObj(r -> {
            Object[] data = new Object[r];
            return CombinationUtil.combinationHelper(items, data, 0, items.length - 1, 0, r);
        }).flatMap(Function.identity());
    }

    public static <T> Stream<List<T>> of(Collection<T> items) {
        return CombinationUtil.of(items.toArray());
    }

    private static <T> Stream<List<T>> combinationHelper(T[] arr, T[] data, int start, int end, int index, int r) {
        if (index == r) {
            return Stream.of(CombinationUtil.asList(data, r));
        }
        return IntStream.rangeClosed(start, end).filter(i -> end - i + 1 >= r - index).mapToObj(i -> {
            data[index] = arr[i];
            return CombinationUtil.combinationHelper(arr, data, i + 1, end, index + 1, r);
        }).flatMap(Function.identity());
    }

    private static <T> List<T> asList(T[] array, int newSize) {
        return Stream.of(array).limit(newSize).collect(Collectors.toList());
    }
}

