/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.generator.core.GeneratorBundle;
import com.speedment.generator.core.component.EventComponent;
import com.speedment.generator.core.event.Event;
import com.speedment.runtime.application.provider.DefaultApplicationBuilder;
import com.speedment.runtime.application.provider.DefaultApplicationMetadata;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.util.EmailUtil;
import com.speedment.tool.core.InjectorHolder;
import com.speedment.tool.core.ToolBundle;
import com.speedment.tool.core.brand.Palette;
import com.speedment.tool.core.event.UIEvent;
import com.speedment.tool.core.internal.component.UserInterfaceComponentImpl;
import com.speedment.tool.core.resource.FontAwesome;
import com.speedment.tool.core.util.InjectionLoader;
import java.util.Objects;
import javafx.application.Application;
import javafx.stage.Stage;

public final class MainApp
extends Application {
    private static final Logger LOGGER = LoggerManager.getLogger(MainApp.class);

    public static void setInjector(Injector injector) {
        InjectorHolder.INSTANCE.setInjector(injector);
    }

    public void start(Stage stage) {
        Objects.requireNonNull(stage);
        InjectorBuilder.logger().setLevel(Level.DEBUG);
        if (InjectorHolder.INSTANCE.getInjector() == null) {
            LOGGER.warn("Creating new Speedment instance for UI session.");
            Injector newInjector = (Injector)((DefaultApplicationBuilder)((DefaultApplicationBuilder)new DefaultApplicationBuilder(((Object)((Object)this)).getClass().getClassLoader(), DefaultApplicationMetadata.class).withBundle(GeneratorBundle.class)).withComponent(ToolBundle.class)).build().getOrThrow(Injector.class);
            InjectorHolder.INSTANCE.setInjector(newInjector);
        }
        Injector injector = InjectorHolder.INSTANCE.getInjector();
        UserInterfaceComponentImpl ui = (UserInterfaceComponentImpl)injector.getOrThrow(UserInterfaceComponentImpl.class);
        ProjectComponent projects = (ProjectComponent)injector.getOrThrow(ProjectComponent.class);
        EventComponent events = (EventComponent)injector.getOrThrow(EventComponent.class);
        InjectionLoader loader = (InjectionLoader)injector.getOrThrow(InjectionLoader.class);
        events.on(UIEvent.class, ev -> {
            if (ev == UIEvent.OPEN_MAIN_WINDOW) {
                ui.showNotification("You are running Speedment Open Source. Click here to upgrade to Speedment Enterprise.", FontAwesome.PLUS, Palette.SUCCESS, () -> ui.browse("https://speedment.com/pricing"));
            }
        });
        ui.start(this, stage);
        if (EmailUtil.hasEmail()) {
            if (projects.getProject().dbmses().noneMatch(dbms -> true)) {
                loader.loadAndShow("Connect");
                stage.setTitle("Connect to database");
            } else {
                loader.loadAndShow("Scene");
                events.notify((Event)UIEvent.OPEN_MAIN_WINDOW);
                ui.showNotification("Metadata has been loaded from an offline file. Click here to reload from database.", FontAwesome.REFRESH, Palette.INFO, ui::reload);
            }
        } else {
            loader.loadAndShow("MailPrompt");
        }
    }

    public static void main(String[] args) {
        MainApp.launch((String[])args);
    }
}

