/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.component;

import com.speedment.common.injector.InjectBundle;
import com.speedment.common.injector.Injector;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerEvent;
import com.speedment.common.logger.LoggerManager;
import com.speedment.generator.translator.TranslatorSupport;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.runtime.core.component.PasswordComponent;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.util.ProgressMeasure;
import com.speedment.runtime.core.util.Statistics;
import com.speedment.tool.config.DbmsProperty;
import com.speedment.tool.config.DocumentProperty;
import com.speedment.tool.config.ProjectProperty;
import com.speedment.tool.config.component.DocumentPropertyComponent;
import com.speedment.tool.config.provider.DelegateDocumentPropertyComponent;
import com.speedment.tool.core.MainApp;
import com.speedment.tool.core.brand.Palette;
import com.speedment.tool.core.component.RuleComponent;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.internal.component.IssueComponentImpl;
import com.speedment.tool.core.internal.component.RuleComponentImpl;
import com.speedment.tool.core.internal.notification.NotificationImpl;
import com.speedment.tool.core.internal.util.ConfigFileHelper;
import com.speedment.tool.core.internal.util.InjectionLoaderImpl;
import com.speedment.tool.core.internal.util.Throttler;
import com.speedment.tool.core.notification.Notification;
import com.speedment.tool.core.provider.DelegateSpeedmentBrand;
import com.speedment.tool.core.resource.FontAwesome;
import com.speedment.tool.core.resource.Icon;
import com.speedment.tool.core.util.BrandUtil;
import com.speedment.tool.core.util.InjectionLoader;
import com.speedment.tool.core.util.OutputUtil;
import com.speedment.tool.propertyeditor.PropertyEditor;
import com.speedment.tool.propertyeditor.provider.DelegatePropertyEditorComponent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;

public final class UserInterfaceComponentImpl
implements UserInterfaceComponent {
    private static final Logger LOGGER = LoggerManager.getLogger(UserInterfaceComponentImpl.class);
    private static final String MANUAL_URI = "https://speedment.github.io/speedment-doc/index.html";
    private static final String GITTER_URI = "https://gitter.im/speedment/speedment/";
    private static final String ISSUE_URI = "https://github.com/speedment/speedment/issues/new";
    private static final String GITHUB_URI = "https://github.com/speedment/speedment/";
    private static final Predicate<Optional<char[]>> NO_PASSWORD_SPECIFIED = pass -> !pass.isPresent() || ((char[])pass.get()).length == 0;
    private final BooleanProperty projectTreeVisible = new SimpleBooleanProperty(true);
    private final BooleanProperty workspaceVisible = new SimpleBooleanProperty(true);
    private final BooleanProperty outputVisible = new SimpleBooleanProperty(false);
    private final ObservableList<Notification> notifications;
    private final ObservableList<Node> outputMessages;
    private final ObservableList<TreeItem<DocumentProperty>> selectedTreeItems;
    private final ObservableList<PropertyEditor.Item> properties;
    private final AtomicBoolean canGenerate;
    private final DocumentPropertyComponent documentPropertyComponent;
    private final PasswordComponent passwordComponent;
    private final ProjectComponent projectComponent;
    private final ConfigFileHelper configFileHelper;
    private final InjectionLoader loader;
    private final RuleComponent rules;
    private final InfoComponent info;
    private Injector injector;
    private Stage stage;
    private Application application;
    private ProjectProperty project;

    public UserInterfaceComponentImpl(DocumentPropertyComponent documentPropertyComponent, PasswordComponent passwordComponent, ProjectComponent projectComponent, ConfigFileHelper configFileHelper, InjectionLoader loader, RuleComponent rules, InfoComponent info) {
        this.documentPropertyComponent = Objects.requireNonNull(documentPropertyComponent);
        this.passwordComponent = Objects.requireNonNull(passwordComponent);
        this.projectComponent = Objects.requireNonNull(projectComponent);
        this.configFileHelper = Objects.requireNonNull(configFileHelper);
        this.loader = Objects.requireNonNull(loader);
        this.rules = Objects.requireNonNull(rules);
        this.info = Objects.requireNonNull(info);
        this.notifications = FXCollections.observableArrayList();
        this.outputMessages = FXCollections.observableArrayList();
        this.selectedTreeItems = FXCollections.observableArrayList();
        this.properties = FXCollections.observableArrayList();
        this.canGenerate = new AtomicBoolean(true);
    }

    @ExecuteBefore(value=State.INITIALIZED)
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector);
    }

    public static InjectBundle include() {
        return InjectBundle.of((Class[])new Class[]{DelegateDocumentPropertyComponent.class, DelegateSpeedmentBrand.class, InjectionLoaderImpl.class, ConfigFileHelper.class, DelegatePropertyEditorComponent.class, RuleComponentImpl.class, IssueComponentImpl.class});
    }

    @Override
    public void start(Application application, Stage stage) {
        this.stage = Objects.requireNonNull(stage);
        this.application = Objects.requireNonNull(application);
        this.project = new ProjectProperty();
        Throttler throttler = Throttler.limitToOnceEvery(2000L);
        LoggerManager.getFactory().addListener(ev -> {
            switch (ev.getLevel()) {
                case DEBUG: 
                case TRACE: 
                case INFO: {
                    this.addToOutputMessages((Node)OutputUtil.info(ev.getMessage()));
                    break;
                }
                case WARN: {
                    this.outputWarningAndShowNotification(throttler, (LoggerEvent)ev);
                    break;
                }
                case ERROR: 
                case FATAL: {
                    this.addToOutputMessages((Node)OutputUtil.error(ev.getMessage()));
                }
            }
        });
        Project loaded = this.projectComponent.getProject();
        if (loaded != null) {
            this.project.merge(this.documentPropertyComponent, loaded);
        }
        Statistics.report((InfoComponent)this.info, (ProjectComponent)this.projectComponent, (Statistics.Event)Statistics.Event.GUI_STARTED);
    }

    private void outputWarningAndShowNotification(Throttler throttler, LoggerEvent ev) {
        this.addToOutputMessages((Node)OutputUtil.warning(ev.getMessage()));
        String title = "There are warnings. See output.";
        throttler.call("There are warnings. See output.", () -> this.showNotification("There are warnings. See output.", FontAwesome.EXCLAMATION_CIRCLE, Palette.WARNING, () -> this.outputVisible.set(true)));
    }

    private void addToOutputMessages(Node node) {
        Platform.runLater(() -> this.outputMessages.add((Object)node));
    }

    @Override
    public ProjectProperty projectProperty() {
        return this.project;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public ObservableList<Notification> notifications() {
        return this.notifications;
    }

    @Override
    public ObservableList<Node> outputMessages() {
        return this.outputMessages;
    }

    @Override
    public ObservableList<TreeItem<DocumentProperty>> getSelectedTreeItems() {
        return this.selectedTreeItems;
    }

    @Override
    public ObservableList<PropertyEditor.Item> getProperties() {
        return this.properties;
    }

    @Override
    public void newProject() {
        try {
            MainApp.setInjector(this.injector.newBuilder().build());
            MainApp app = new MainApp();
            Stage newStage = new Stage();
            app.start(newStage);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            this.showError("Could not create empty project", e.getMessage(), e);
        }
    }

    @Override
    public void openProject() {
        this.openProject(UserInterfaceComponent.ReuseStage.CREATE_A_NEW_STAGE);
    }

    @Override
    public void openProject(UserInterfaceComponent.ReuseStage reuse) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open .json File");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("JSON files (*.json)", new String[]{"*.json"}));
        File file = fileChooser.showOpenDialog((Window)this.stage);
        if (file != null) {
            this.configFileHelper.loadConfigFile(file, reuse);
        }
    }

    @Override
    public void saveProject() {
        if (this.configFileHelper.isFileOpen()) {
            this.configFileHelper.saveCurrentlyOpenConfigFile();
        } else {
            this.configFileHelper.saveConfigFile();
        }
    }

    @Override
    public void saveProjectAs() {
        this.configFileHelper.saveConfigFile();
    }

    @Override
    public void quit() {
        this.stage.close();
    }

    @Override
    public void reload() {
        if (this.showWarning("Do you really want to do this?", "Reloading the project will remove any changes you have done to the project. Are you sure you want to continue?").filter(ButtonType.OK::equals).isPresent()) {
            this.project.dbmses().filter(dbms -> NO_PASSWORD_SPECIFIED.test(this.passwordComponent.get(dbms))).map(DbmsProperty.class::cast).forEach(this::showPasswordDialog);
            Optional<String> schemaName = this.project.dbmses().flatMap(Dbms::schemas).map(HasId::getId).findAny();
            if (schemaName.isPresent()) {
                this.project.dbmses().map(DbmsProperty.class::cast).forEach(dbms -> this.configFileHelper.loadFromDatabase((DbmsProperty)dbms, (String)schemaName.get()));
                Statistics.report((InfoComponent)this.info, (ProjectComponent)this.projectComponent, (Statistics.Event)Statistics.Event.GUI_PROJECT_LOADED);
            } else {
                this.showError("No Schema Found", "Can not connect to the database without at least one schema specified.");
            }
        }
    }

    @Override
    public void generate() {
        boolean allowed = this.canGenerate.getAndSet(false);
        if (!allowed) {
            return;
        }
        this.clearLog();
        TranslatorSupport support = new TranslatorSupport(this.injector, (Document)this.project);
        this.log(OutputUtil.info("Preparing for generating classes " + support.basePackageName() + "." + this.project.getId() + ".*"));
        this.log(OutputUtil.info("Target directory is " + this.project.getPackageLocation()));
        this.log(OutputUtil.info("Performing rule verifications..."));
        Project immutableProject = Project.createImmutable((Project)this.project);
        this.projectComponent.setProject(immutableProject);
        CompletableFuture<Boolean> future = this.rules.verify();
        future.handleAsync((bool, ex) -> {
            if (ex != null) {
                String err = "An error occurred while the error checker was looking for issues in the project configuration.";
                LOGGER.error(ex, "An error occurred while the error checker was looking for issues in the project configuration.");
                Platform.runLater(() -> {
                    this.showError("Error Creating Report", "An error occurred while the error checker was looking for issues in the project configuration.", (Throwable)ex);
                    this.canGenerate.set(true);
                });
            } else if (!bool.booleanValue()) {
                Platform.runLater(() -> {
                    this.showIssues();
                    this.canGenerate.set(true);
                });
            } else {
                Platform.runLater(() -> this.log(OutputUtil.info("Rule verifications completed")));
                if (!this.configFileHelper.isFileOpen()) {
                    this.configFileHelper.setCurrentlyOpenFile(new File("src/main/json/speedment.json"));
                }
                this.configFileHelper.saveCurrentlyOpenConfigFile();
                this.configFileHelper.generateSources();
                this.canGenerate.set(true);
            }
            return bool;
        });
    }

    @Override
    public void showManual() {
        this.browse(MANUAL_URI);
    }

    @Override
    public void showGitter() {
        this.browse(GITTER_URI);
    }

    @Override
    public void reportIssue() {
        this.browse(ISSUE_URI);
    }

    @Override
    public void showGithub() {
        this.browse(GITHUB_URI);
    }

    @Override
    public BooleanProperty projectTreeVisibleProperty() {
        return this.projectTreeVisible;
    }

    @Override
    public BooleanProperty workspaceVisibleProperty() {
        return this.workspaceVisible;
    }

    @Override
    public BooleanProperty outputVisibleProperty() {
        return this.outputVisible;
    }

    @Override
    public void prepareProjectTree(SplitPane parent, Node projectTree) {
        if (!this.projectTreeVisible.get()) {
            parent.getItems().remove((Object)projectTree);
        }
        this.projectTreeVisible.addListener((ob, o, visible) -> {
            if (visible.booleanValue()) {
                parent.getItems().add(0, (Object)projectTree);
            } else {
                parent.getItems().remove((Object)projectTree);
            }
        });
    }

    @Override
    public void prepareWorkspace(SplitPane parent, Node workspace) {
        if (!this.workspaceVisible.get()) {
            parent.getItems().remove((Object)workspace);
        }
        this.workspaceVisible.addListener((ob, o, visible) -> {
            if (visible.booleanValue()) {
                parent.getItems().add(0, (Object)workspace);
            } else {
                parent.getItems().remove((Object)workspace);
            }
        });
    }

    @Override
    public void prepareOutput(SplitPane parent, Node output) {
        if (!this.outputVisible.get()) {
            parent.getItems().remove((Object)output);
        }
        this.outputVisible.addListener((ob, o, visible) -> {
            if (visible.booleanValue()) {
                parent.getItems().add((Object)output);
            } else {
                parent.getItems().remove((Object)output);
            }
        });
    }

    @Override
    public void showError(String title, String message) {
        this.showError(title, message, null);
    }

    @Override
    public void showError(String title, String message, Throwable ex) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        Scene scene = alert.getDialogPane().getScene();
        BrandUtil.applyBrand(this.injector, this.stage, scene);
        alert.setHeaderText(title);
        alert.setContentText(message);
        alert.setGraphic(FontAwesome.EXCLAMATION_TRIANGLE.view());
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        if (ex == null) {
            alert.setTitle("Error");
        } else {
            alert.setTitle(ex.getClass().getSimpleName());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            Label label = new Label("The exception stacktrace was:");
            String exceptionText = sw.toString();
            TextArea textArea = new TextArea(exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
            alert.getDialogPane().setExpandableContent((Node)expContent);
        }
        alert.showAndWait();
    }

    @Override
    public Optional<ButtonType> showWarning(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Scene scene = alert.getDialogPane().getScene();
        BrandUtil.applyBrand(this.injector, this.stage, scene);
        alert.setTitle("Confirmation");
        alert.setHeaderText(title);
        alert.setContentText(message);
        alert.setGraphic(FontAwesome.EXCLAMATION_TRIANGLE.view());
        return alert.showAndWait();
    }

    @Override
    public void showPasswordDialog(DbmsProperty dbms) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Authentication Required");
        dialog.setHeaderText("Enter password for " + dbms.getName());
        dialog.setGraphic(FontAwesome.LOCK.view());
        DialogPane pane = dialog.getDialogPane();
        pane.getStyleClass().add((Object)"authentication");
        Scene scene = pane.getScene();
        BrandUtil.applyBrand(this.injector, this.stage, scene);
        ButtonType authButtonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        pane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, authButtonType});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        TextField username = new TextField(dbms.getUsername().orElse("Root"));
        username.setPromptText("Username");
        PasswordField password = new PasswordField();
        password.setPromptText("Password");
        grid.add((Node)new Label("Username:"), 0, 0);
        grid.add((Node)username, 1, 0);
        grid.add((Node)new Label("Password:"), 0, 1);
        grid.add((Node)password, 1, 1);
        Node loginButton = pane.lookupButton(authButtonType);
        username.textProperty().addListener((ob, o, n) -> loginButton.setDisable(n.trim().isEmpty()));
        pane.setContent((Node)grid);
        Platform.runLater(() -> ((TextField)username).requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == authButtonType) {
                return new Pair((Object)username.getText(), (Object)password.getText().toCharArray());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(usernamePassword -> {
            dbms.mutator().setUsername((String)usernamePassword.getKey());
            this.passwordComponent.put((Dbms)dbms, (char[])usernamePassword.getValue());
        });
    }

    @Override
    public void showProgressDialog(String title, ProgressMeasure progress, CompletableFuture<Boolean> task) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Progress Tracker");
        dialog.setHeaderText(title);
        dialog.setGraphic(FontAwesome.SPINNER.view());
        DialogPane pane = dialog.getDialogPane();
        pane.getStyleClass().add((Object)"progress");
        VBox box = new VBox();
        ProgressBar bar = new ProgressBar();
        Label message = new Label();
        Button cancel = new Button("Cancel", FontAwesome.TIMES.view());
        Pane filler = new Pane();
        HBox fillerContainer = new HBox(new Node[]{filler, cancel});
        HBox.setHgrow((Node)filler, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)cancel, (Priority)Priority.SOMETIMES);
        filler.setMaxWidth(Double.MAX_VALUE);
        fillerContainer.setMaxWidth(Double.MAX_VALUE);
        box.getChildren().addAll((Object[])new Node[]{bar, message, fillerContainer});
        box.setMaxWidth(Double.MAX_VALUE);
        bar.setMaxWidth(Double.MAX_VALUE);
        message.setMaxWidth(Double.MAX_VALUE);
        cancel.setMaxWidth(128.0);
        VBox.setVgrow((Node)message, (Priority)Priority.ALWAYS);
        box.setFillWidth(true);
        box.setSpacing(8.0);
        progress.addListener(measure -> {
            String msg = measure.getCurrentAction();
            double prg = measure.getProgress();
            boolean done = measure.isDone();
            Platform.runLater(() -> {
                if (done) {
                    dialog.setResult((Object)true);
                    dialog.close();
                } else {
                    message.setText(msg);
                    bar.setProgress(prg);
                }
            });
        });
        cancel.setOnAction(ev -> {
            if (!task.cancel(true)) {
                LOGGER.error("Failed to cancel task.");
            }
            progress.setCurrentAction("Cancelling...");
            progress.setProgress(1.0);
        });
        pane.setContent((Node)box);
        pane.setMaxWidth(Double.MAX_VALUE);
        Scene scene = pane.getScene();
        BrandUtil.applyBrand(this.injector, this.stage, scene);
        if (!progress.isDone()) {
            dialog.showAndWait();
        }
    }

    @Override
    public void showIssues() {
        this.loader.loadAsModal("ProjectProblem");
    }

    @Override
    public void showNotification(String message) {
        this.showNotification(message, FontAwesome.EXCLAMATION_CIRCLE);
    }

    @Override
    public void showNotification(String message, Icon icon) {
        this.showNotification(message, icon, Palette.INFO);
    }

    @Override
    public void showNotification(String message, Runnable action) {
        this.showNotification(message, FontAwesome.EXCLAMATION_CIRCLE, Palette.INFO, action);
    }

    @Override
    public void showNotification(String message, Palette palette) {
        this.showNotification(message, FontAwesome.EXCLAMATION_CIRCLE, palette);
    }

    @Override
    public void showNotification(String message, Icon icon, Palette palette) {
        this.showNotification(message, icon, palette, () -> {});
    }

    @Override
    public void showNotification(String message, Icon icon, Palette palette, Runnable action) {
        Platform.runLater(() -> this.notifications.add((Object)new NotificationImpl(message, icon, palette, action)));
    }

    @Override
    public void clearLog() {
        Platform.runLater(() -> this.outputMessages.clear());
    }

    @Override
    public void log(Label line) {
        Platform.runLater(() -> this.outputMessages.add((Object)line));
    }

    @Override
    public void browse(String url) {
        this.application.getHostServices().showDocument(url);
    }
}

