/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.component;

import com.speedment.common.rest.Option;
import com.speedment.common.rest.Rest;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.tool.core.component.VersionComponent;
import com.speedment.tool.core.exception.SpeedmentToolException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class VersionComponentImpl
implements VersionComponent {
    private final InfoComponent info;

    public VersionComponentImpl(InfoComponent info) {
        this.info = Objects.requireNonNull(info);
    }

    @Override
    public CompletableFuture<String> latestVersion() {
        return Rest.connectHttps((String)"service.speedment.com").get(String.format("version/%s/latest", this.info.getRepository()), new Option[0]).thenApplyAsync(res -> {
            if (res.success()) {
                return res.decodeJson().map(m -> (Map)m).map(m -> (String)m.get("tag")).orElseThrow(() -> new SpeedmentToolException("Could not establish the latest version."));
            }
            throw new SpeedmentToolException("Received an error '" + res.getText() + "' from the GitHub API.");
        });
    }
}

