/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.InjectKey;
import com.speedment.common.mapstream.MapStream;
import com.speedment.generator.translator.component.CodeGenerationComponent;
import com.speedment.runtime.core.Speedment;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.typemapper.TypeMapper;
import com.speedment.runtime.typemapper.TypeMapperComponent;
import com.speedment.tool.core.internal.util.CloseUtil;
import com.speedment.tool.core.resource.SpeedmentIcon;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class ComponentsController
implements Initializable {
    @Inject
    public InfoComponent infoComponent;
    @Inject
    public Speedment speedment;
    @Inject
    public Injector injector;
    @FXML
    private Label title;
    @FXML
    private Label header;
    @FXML
    private Button close;
    @FXML
    private TreeView<String> tree;

    public void initialize(URL location, ResourceBundle resources) {
        this.title.setTextFill((Paint)Color.web((String)"#45a6fc"));
        this.header.setText("Component Explorer");
        RootItem root = new RootItem(this.speedment);
        root.getChildren().addAll(this.components());
        this.tree.setRoot((TreeItem)root);
        this.close.setOnAction(CloseUtil.newCloseHandler());
    }

    private List<TreeItem<String>> components() {
        return this.injector.injectables().map(this::treeItem).sorted(MapStream.comparing((Function[])new Function[]{TreeItem::getValue})).collect(Collectors.toList());
    }

    public static Stream<Class<?>> traverseAncestors(Class<?> clazz) {
        if (clazz.getSuperclass() == null) {
            return Stream.of(clazz);
        }
        return Stream.concat(Stream.of(clazz), Stream.concat(ComponentsController.traverseAncestors(clazz.getSuperclass()), Stream.of(clazz.getInterfaces()))).distinct();
    }

    private TreeItem<String> treeItem(Class<?> comp) {
        ComponentItem item = new ComponentItem(comp);
        if (CodeGenerationComponent.class.isAssignableFrom(comp)) {
            TranslatorsItem translators = new TranslatorsItem();
            this.injector.get(CodeGenerationComponent.class).ifPresent(cg -> cg.translatorKeys().sorted().map(x$0 -> new TranslatorItem((String)x$0)).forEachOrdered(arg_0 -> translators.getChildren().add(arg_0)));
            if (!translators.getChildren().isEmpty()) {
                item.getChildren().add((Object)translators);
            }
        }
        if (DbmsHandlerComponent.class.isAssignableFrom(comp)) {
            DbmsTypesItem dbmsTypes = new DbmsTypesItem();
            this.injector.get(DbmsHandlerComponent.class).ifPresent(dh -> dh.supportedDbmsTypes().sorted(Comparator.comparing(DbmsType::getName)).map(x$0 -> new DbmsTypeItem((DbmsType)x$0)).forEachOrdered(arg_0 -> dbmsTypes.getChildren().add(arg_0)));
            if (!dbmsTypes.getChildren().isEmpty()) {
                item.getChildren().add((Object)dbmsTypes);
            }
        }
        if (TypeMapperComponent.class.isAssignableFrom(comp)) {
            TypeMappersItem typeMappers = new TypeMappersItem();
            this.injector.get(TypeMapperComponent.class).ifPresent(tm -> tm.stream().sorted(TypeMapper.standardComparator()).map(x$0 -> new TypeMapperItem((TypeMapper)x$0)).forEachOrdered(arg_0 -> typeMappers.getChildren().add(arg_0)));
            if (!typeMappers.getChildren().isEmpty()) {
                item.getChildren().add((Object)typeMappers);
            }
        }
        return item;
    }

    private static class TypeMapperItem
    extends TreeItem<String> {
        private TypeMapperItem(TypeMapper<?, ?> typeMapper) {
            super((Object)typeMapper.getLabel());
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.CUP.view());
        }
    }

    private static class TypeMappersItem
    extends TreeItem<String> {
        private TypeMappersItem() {
            super((Object)"Installed Type Mappings");
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.PAGE_WHITE_CUP.view());
        }
    }

    private static class DbmsTypeItem
    extends TreeItem<String> {
        private DbmsTypeItem(DbmsType dbmsType) {
            super((Object)dbmsType.getName());
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.DATABASE.view());
        }
    }

    private static class DbmsTypesItem
    extends TreeItem<String> {
        private DbmsTypesItem() {
            super((Object)"Supported Databases");
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.DATABASE_CONNECT.view());
        }
    }

    private static class TranslatorItem
    extends TreeItem<String> {
        private TranslatorItem(String translatorKey) {
            super((Object)translatorKey);
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.BOOK_NEXT.view());
        }
    }

    private static class TranslatorsItem
    extends TreeItem<String> {
        private TranslatorsItem() {
            super((Object)"Code Generators");
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.BOOK_OPEN.view());
        }
    }

    private static class ComponentItem
    extends TreeItem<String> {
        private ComponentItem(Class<?> comp) {
            super((Object)(ComponentItem.injectorKeyValue(comp).map(Class::getSimpleName).orElse(comp.getSimpleName()) + " (" + comp.getSimpleName() + ")"));
            this.setExpanded(false);
            this.setGraphic((Node)SpeedmentIcon.BRICKS.view());
        }

        private static Optional<? extends Class<?>> injectorKeyValue(Class<?> clazz) {
            return ComponentsController.traverseAncestors(clazz).map(c -> c.getAnnotation(InjectKey.class)).filter(Objects::nonNull).map(InjectKey::value).findFirst();
        }
    }

    private class RootItem
    extends TreeItem<String> {
        private RootItem(Speedment speedment) {
            super((Object)(ComponentsController.this.infoComponent.getTitle() + " (0x" + Integer.toHexString(System.identityHashCode(speedment)) + ")"));
            this.setExpanded(true);
            this.setGraphic((Node)SpeedmentIcon.BOX.view());
            ComponentsController.this.title.setText(ComponentsController.this.infoComponent.getTitle());
        }
    }
}

