/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.function.OptionalBoolean;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.generator.core.component.EventComponent;
import com.speedment.generator.core.event.Event;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.PasswordComponent;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.db.DbmsTypeDefault;
import com.speedment.tool.config.DbmsProperty;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.event.UIEvent;
import com.speedment.tool.core.exception.SpeedmentToolException;
import com.speedment.tool.core.internal.util.ConfigFileHelper;
import com.speedment.tool.core.resource.FontAwesome;
import com.speedment.tool.core.util.InjectionLoader;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public final class ConnectController
implements Initializable {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_USER = "root";
    @Inject
    public UserInterfaceComponent ui;
    @Inject
    public DbmsHandlerComponent dbmsHandler;
    @Inject
    public PasswordComponent passwords;
    @Inject
    public ConfigFileHelper cfHelper;
    @Inject
    public EventComponent events;
    @Inject
    public InjectionLoader loader;
    @FXML
    private TextField fieldHost;
    @FXML
    private TextField fieldPort;
    @FXML
    private TextField fieldFile;
    @FXML
    private Button fieldFileBtn;
    @FXML
    private ComboBox<String> fieldType;
    @FXML
    private TextField fieldName;
    @FXML
    private TextField fieldSchema;
    @FXML
    private TextField fieldServer;
    @FXML
    private TextField fieldUser;
    @FXML
    private PasswordField fieldPass;
    @FXML
    private Button buttonConnect;
    @FXML
    private CheckBox enableConnectionUrl;
    @FXML
    private TextArea areaConnectionUrl;
    @FXML
    private GridPane grid;
    @FXML
    private RowConstraints hostRow;
    @FXML
    private RowConstraints fileRow;
    @FXML
    private RowConstraints dbmsRow;
    @FXML
    private RowConstraints schemaRow;
    @FXML
    private RowConstraints serverRow;
    @FXML
    private RowConstraints userRow;
    @FXML
    private RowConstraints passRow;

    public void initialize(URL location, ResourceBundle resources) {
        FilteredList<Node> hostRowChildren = this.inRow(this.hostRow);
        FilteredList<Node> fileRowChildren = this.inRow(this.fileRow);
        FilteredList<Node> userRowChildren = this.inRow(this.userRow);
        FilteredList<Node> passRowChildren = this.inRow(this.passRow);
        FilteredList<Node> dbmsRowChildren = this.inRow(this.dbmsRow);
        FilteredList<Node> schemaRowChildren = this.inRow(this.schemaRow);
        FilteredList<Node> serverRowChildren = this.inRow(this.serverRow);
        this.fieldFileBtn.setGraphic(FontAwesome.FOLDER_OPEN.view());
        this.buttonConnect.setGraphic(FontAwesome.SIGN_IN.view());
        this.fieldType.setItems(this.getDbmsTypes().collect(Collectors.toCollection(FXCollections::observableArrayList)));
        AtomicReference<DbmsType> dbmsType = new AtomicReference<DbmsType>();
        AtomicReference<String> generatedHost = new AtomicReference<String>("");
        AtomicReference<String> generatedPort = new AtomicReference<String>("");
        AtomicReference<String> generatedUser = new AtomicReference<String>("");
        AtomicReference<String> generatedName = new AtomicReference<String>("");
        AtomicReference<String> generatedSchema = new AtomicReference<String>("");
        AtomicReference<String> generatedServer = new AtomicReference<String>("");
        AtomicReference<String> generatedConnUrl = new AtomicReference<String>("");
        Runnable recalculateFields = () -> {
            DbmsType item = (DbmsType)dbmsType.get();
            this.toggleVisibility(this.hostRow, hostRowChildren, item.getConnectionType() == DbmsTypeDefault.ConnectionType.HOST_AND_PORT);
            this.toggleVisibility(this.fileRow, fileRowChildren, item.getConnectionType() == DbmsTypeDefault.ConnectionType.DBMS_AS_FILE);
            this.toggleVisibility(this.userRow, userRowChildren, item.hasDatabaseUsers());
            this.toggleVisibility(this.passRow, passRowChildren, item.hasDatabaseUsers());
            this.toggleVisibility(this.dbmsRow, dbmsRowChildren, item.hasDatabaseNames());
            this.toggleVisibility(this.schemaRow, schemaRowChildren, item.hasSchemaNames());
            this.toggleVisibility(this.serverRow, serverRowChildren, item.hasServerNames());
            if (this.fieldHost.getText().isEmpty() || this.fieldHost.getText().equals(generatedHost.get())) {
                this.fieldHost.textProperty().setValue(DEFAULT_HOST);
                generatedHost.set(DEFAULT_HOST);
            }
            this.disableDbmsUserPropertyForDbmsesThatDoesNotUseIt(generatedUser, item);
            this.disableDbmsNamePropertyForDmbsesThatDoesNotUseIt(generatedPort, generatedName, generatedSchema, generatedServer, item);
        };
        Runnable recalculateConnUrl = () -> this.recalculateConnUrl(dbmsType, generatedConnUrl);
        this.setupRecalculateDefaultValuesOnUserChange(dbmsType, recalculateFields, recalculateConnUrl);
        this.areaConnectionUrl.disableProperty().bind((ObservableValue)this.enableConnectionUrl.selectedProperty().not());
        this.fieldFileBtn.disableProperty().bind((ObservableValue)this.enableConnectionUrl.selectedProperty());
        Optional<String> preferred = this.getDbmsTypes().findFirst();
        if (!preferred.isPresent()) {
            String msg = "Could not find any installed JDBC drivers. Make sure to include at least one JDBC driver as a dependency in the projects pom.xml-file under the speedment-maven-plugin <plugin> tag.";
            this.ui.showError("Couldn't find any installed JDBC drivers", "Could not find any installed JDBC drivers. Make sure to include at least one JDBC driver as a dependency in the projects pom.xml-file under the speedment-maven-plugin <plugin> tag.");
            throw new SpeedmentToolException("Could not find any installed JDBC drivers. Make sure to include at least one JDBC driver as a dependency in the projects pom.xml-file under the speedment-maven-plugin <plugin> tag.");
        }
        this.fieldType.getSelectionModel().select((Object)preferred.get());
        this.disableConnectButtonIfAnyFieldIsNotEntered(dbmsType);
        this.fieldFileBtn.setOnAction(this.loadDmbsFromFileAction());
        this.buttonConnect.setOnAction(this.connectToDatabaseAction(dbmsType, generatedConnUrl));
    }

    private void setupRecalculateDefaultValuesOnUserChange(AtomicReference<DbmsType> dbmsType, Runnable recalculateFields, Runnable recalculateConnUrl) {
        this.fieldType.getSelectionModel().selectedItemProperty().addListener((observable, old, typeName) -> {
            if (!typeName.isEmpty()) {
                dbmsType.set(this.findDbmsType((String)typeName));
                recalculateFields.run();
                recalculateConnUrl.run();
            }
        });
        this.fieldHost.textProperty().addListener((ob, o, n) -> recalculateConnUrl.run());
        this.fieldPort.textProperty().addListener((ob, o, n) -> recalculateConnUrl.run());
        this.fieldFile.textProperty().addListener((ob, o, n) -> recalculateConnUrl.run());
        this.fieldName.textProperty().addListener((ob, o, n) -> recalculateConnUrl.run());
        this.fieldServer.textProperty().addListener((ob, o, n) -> recalculateConnUrl.run());
        this.fieldHost.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldHost));
        UnaryOperator onlyDigitsFilter = change -> change.getText().matches("[0-9]*") ? change : null;
        this.fieldPort.setTextFormatter(new TextFormatter(onlyDigitsFilter));
        this.fieldPort.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldPort));
        this.fieldFile.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldFile));
        this.fieldUser.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldUser));
        this.fieldName.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldName));
        this.fieldSchema.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldSchema));
        this.fieldServer.focusedProperty().addListener((ob, o, n) -> this.recalculateOnLostFocusAndEmptyField(recalculateFields, (Boolean)o, this.fieldServer));
    }

    private void recalculateOnLostFocusAndEmptyField(Runnable recalculateFields, Boolean oldValue, TextField field) {
        if (oldValue.booleanValue() && field.getText().isEmpty()) {
            recalculateFields.run();
        }
    }

    private void disableConnectButtonIfAnyFieldIsNotEntered(AtomicReference<DbmsType> dbmsType) {
        this.buttonConnect.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> (this.fieldHost.textProperty().isEmpty().get() || this.fieldPort.textProperty().isEmpty().get()) && ((DbmsType)dbmsType.get()).getConnectionType() == DbmsTypeDefault.ConnectionType.HOST_AND_PORT || this.fieldFile.textProperty().isEmpty().get() && ((DbmsType)dbmsType.get()).getConnectionType() == DbmsTypeDefault.ConnectionType.DBMS_AS_FILE || this.fieldType.getSelectionModel().isEmpty() || this.fieldName.textProperty().isEmpty().get() && ((DbmsType)dbmsType.get()).hasDatabaseNames() || this.fieldUser.textProperty().isEmpty().get() && ((DbmsType)dbmsType.get()).hasDatabaseUsers() || this.fieldServer.textProperty().isEmpty().get() && ((DbmsType)dbmsType.get()).hasServerNames(), (Observable[])new Observable[]{this.fieldHost.textProperty(), this.fieldPort.textProperty(), this.fieldFile.textProperty(), this.fieldType.selectionModelProperty(), this.fieldName.textProperty(), this.fieldUser.textProperty(), this.fieldServer.textProperty()}));
    }

    private EventHandler<ActionEvent> loadDmbsFromFileAction() {
        return ev -> {
            File file;
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Open Database File");
            if (!"".equals(this.fieldFile.getText().trim())) {
                String parentFolder;
                Path path = Paths.get(this.fieldFile.getText().trim(), new String[0]);
                if (path.getParent().toFile().exists() && !"".equals(parentFolder = path.getParent().toString())) {
                    fileChooser.setInitialDirectory(new File(parentFolder));
                }
                if (path.toFile().exists()) {
                    fileChooser.setInitialFileName(this.fieldFile.getText());
                }
            }
            if ((file = fileChooser.showOpenDialog((Window)this.ui.getStage())) != null) {
                this.fieldFile.setText(Paths.get(".", new String[0]).toAbsolutePath().getParent().relativize(file.toPath()).toString());
            }
        };
    }

    private EventHandler<ActionEvent> connectToDatabaseAction(AtomicReference<DbmsType> dbmsType, AtomicReference<String> generatedConnUrl) {
        return ev -> {
            DbmsType type = (DbmsType)dbmsType.get();
            this.passwords.put(this.fieldName.getText(), this.fieldPass.getText().toCharArray());
            DbmsProperty dbms = this.ui.projectProperty().mutator().addNewDbms();
            this.setDbmsProperties(dbmsType, generatedConnUrl, type, dbms);
            String schema = Optional.of(this.fieldSchema.getText()).filter(s -> ((DbmsType)dbmsType.get()).hasSchemaNames()).filter(s -> !s.isEmpty()).orElseGet(() -> type.getDefaultSchemaName().orElseGet(() -> ((DbmsProperty)dbms).getName()));
            this.setDefaultProjectName(type, schema);
            if (this.cfHelper.loadFromDatabase(dbms, schema)) {
                this.loader.loadAndShow("Scene");
                this.events.notify((Event)UIEvent.OPEN_MAIN_WINDOW);
            }
        };
    }

    private void setDbmsProperties(AtomicReference<DbmsType> dbmsType, AtomicReference<String> generatedConnUrl, DbmsType type, DbmsProperty dbms) {
        dbms.typeNameProperty().set((Object)dbmsType.get().getName());
        if (type.getConnectionType() == DbmsTypeDefault.ConnectionType.HOST_AND_PORT) {
            dbms.ipAddressProperty().set((Object)this.fieldHost.getText());
            dbms.portProperty().set(Integer.parseInt(this.fieldPort.getText()));
        } else if (type.getConnectionType() == DbmsTypeDefault.ConnectionType.DBMS_AS_FILE) {
            dbms.localPathProperty().set((Object)this.fieldFile.getText());
        }
        if (type.hasDatabaseUsers()) {
            dbms.usernameProperty().set((Object)this.fieldUser.getText());
        }
        if (type.hasServerNames()) {
            dbms.serverNameProperty().set((Object)this.fieldServer.getText());
        }
        dbms.nameProperty().set((Object)Optional.of(this.fieldName.getText()).filter(s -> ((DbmsType)dbmsType.get()).hasDatabaseNames()).filter(s -> !s.isEmpty()).orElseGet(() -> type.getDefaultDbmsName().orElseGet(() -> ((TextField)this.fieldName).getText())));
        if (!this.areaConnectionUrl.getText().isEmpty() && !this.areaConnectionUrl.getText().equals(generatedConnUrl.get())) {
            dbms.connectionUrlProperty().setValue(this.areaConnectionUrl.getText());
        }
    }

    private void setDefaultProjectName(DbmsType type, String schema) {
        if (type.hasSchemaNames() || type.hasDatabaseNames()) {
            this.ui.projectProperty().nameProperty().setValue(schema);
        } else if (type.getConnectionType() == DbmsTypeDefault.ConnectionType.DBMS_AS_FILE) {
            String filename = Paths.get(this.fieldFile.getText(), new String[0]).getFileName().toString();
            if (filename.contains(".")) {
                filename = filename.substring(0, filename.lastIndexOf(46));
            }
            this.ui.projectProperty().nameProperty().setValue(filename);
        } else {
            this.ui.projectProperty().nameProperty().setValue("Demo");
        }
    }

    private void recalculateConnUrl(AtomicReference<DbmsType> dbmsType, AtomicReference<String> generatedConnUrl) {
        DbmsType item = dbmsType.get();
        if (this.areaConnectionUrl.getText().isEmpty() || this.areaConnectionUrl.getText().equals(generatedConnUrl.get())) {
            String url = item.getConnectionUrlGenerator().from((Dbms)TemporaryDbms.create((Project)this.ui.projectProperty(), this.fieldName.getText(), this.fieldFile.getText(), this.fieldHost.getText(), this.fieldPort.getText().isEmpty() ? 0 : Integer.parseInt(this.fieldPort.getText()), this.fieldServer.getText()));
            generatedConnUrl.set(url);
            this.areaConnectionUrl.setText(url);
        }
    }

    private void disableDbmsNamePropertyForDmbsesThatDoesNotUseIt(AtomicReference<String> generatedPort, AtomicReference<String> generatedName, AtomicReference<String> generatedSchema, AtomicReference<String> generatedServer, DbmsType item) {
        if (item.hasDatabaseNames()) {
            this.fieldName.setDisable(false);
            if (this.fieldName.getText().isEmpty() || this.fieldName.getText().equals(generatedName.get())) {
                item.getDefaultDbmsName().ifPresent(name -> {
                    this.fieldName.textProperty().setValue(name);
                    generatedName.set((String)name);
                });
            }
        } else {
            item.getDefaultDbmsName().ifPresent(generatedName::set);
            this.fieldName.setDisable(true);
        }
        if (item.hasSchemaNames()) {
            this.fieldSchema.setDisable(false);
            if (this.fieldSchema.getText().isEmpty() || this.fieldSchema.getText().equals(generatedSchema.get())) {
                item.getDefaultSchemaName().ifPresent(name -> {
                    this.fieldSchema.textProperty().setValue(name);
                    generatedSchema.set((String)name);
                });
            }
        } else {
            this.fieldSchema.setDisable(true);
        }
        if (item.hasServerNames()) {
            this.fieldServer.setDisable(false);
            if (this.fieldServer.getText().isEmpty() || this.fieldServer.getText().equals(generatedServer.get())) {
                item.getDefaultServerName().ifPresent(name -> {
                    this.fieldServer.textProperty().setValue(name);
                    generatedServer.set((String)name);
                });
            }
        } else {
            this.fieldServer.setDisable(true);
        }
        this.fieldName.getTooltip().setText(item.getDbmsNameMeaning());
        if (this.fieldPort.getText().isEmpty() || this.fieldPort.getText().equals(generatedPort.get())) {
            String port = Integer.toString(item.getDefaultPort());
            this.fieldPort.textProperty().setValue(port);
            generatedPort.set(port);
        }
    }

    private void disableDbmsUserPropertyForDbmsesThatDoesNotUseIt(AtomicReference<String> generatedUser, DbmsType item) {
        if (item.hasDatabaseUsers()) {
            this.fieldUser.setDisable(false);
            this.fieldPass.setDisable(false);
            if (this.fieldUser.getText().isEmpty() || this.fieldUser.getText().equals(generatedUser.get())) {
                this.fieldUser.textProperty().setValue(DEFAULT_USER);
                generatedUser.set(DEFAULT_USER);
            }
        } else {
            generatedUser.set(DEFAULT_USER);
            this.fieldUser.setDisable(true);
            this.fieldPass.setDisable(true);
        }
    }

    private Stream<String> getDbmsTypes() {
        return this.dbmsHandler.supportedDbmsTypes().map(DbmsType::getName);
    }

    private DbmsType findDbmsType(String dbmsTypeName) {
        return (DbmsType)this.dbmsHandler.findByName(dbmsTypeName).orElseThrow(() -> new SpeedmentToolException("Could not find any DbmsType with name '" + dbmsTypeName + "'."));
    }

    private FilteredList<Node> inRow(RowConstraints row) {
        int index = this.grid.getRowConstraints().indexOf((Object)row);
        return this.grid.getChildren().filtered(node -> {
            Integer rowIndex = GridPane.getRowIndex((Node)node);
            return rowIndex != null && index == GridPane.getRowIndex((Node)node);
        });
    }

    private void toggleVisibility(RowConstraints row, FilteredList<Node> children, boolean show) {
        if (show) {
            row.setMaxHeight(-1.0);
            row.setMinHeight(10.0);
        } else {
            row.setMaxHeight(0.0);
            row.setMinHeight(0.0);
        }
        children.forEach(n -> {
            n.setVisible(show);
            n.setManaged(show);
        });
    }

    private static final class TemporaryDbms
    implements Dbms {
        private final Project project;
        private final Map<String, Object> data;

        public static TemporaryDbms create(Project project, String name, String file, String ip, int port, String serverName) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put("id", name);
            data.put("name", name);
            data.put("ipAddress", ip);
            if (port != 0) {
                data.put("port", port);
            }
            data.put("localPath", file);
            data.put("serverName", serverName);
            return new TemporaryDbms(project, data);
        }

        private TemporaryDbms(Project project, Map<String, Object> data) {
            this.project = Objects.requireNonNull(project);
            this.data = Objects.requireNonNull(data);
        }

        public Optional<Project> getParent() {
            return Optional.of(this.project);
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public Optional<Object> get(String key) {
            return Optional.ofNullable(this.data.get(key));
        }

        public Optional<String> getAsString(String key) {
            return this.get(key).map(String.class::cast);
        }

        public OptionalBoolean getAsBoolean(String key) {
            return this.get(key).map(Boolean.class::cast).map(OptionalBoolean::of).orElseGet(OptionalBoolean::empty);
        }

        public OptionalLong getAsLong(String key) {
            return this.get(key).map(Long.class::cast).map(OptionalLong::of).orElseGet(OptionalLong::empty);
        }

        public OptionalDouble getAsDouble(String key) {
            return this.get(key).map(Double.class::cast).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
        }

        public OptionalInt getAsInt(String key) {
            return this.get(key).map(Integer.class::cast).map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        public void put(String key, Object value) {
            throw new UnsupportedOperationException("This implementation of Dbms should not be modified.");
        }

        public Stream<Schema> schemas() {
            return Stream.empty();
        }

        public Stream<? extends Document> children() {
            return Stream.empty();
        }
    }
}

