/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.generator.core.component.EventComponent;
import com.speedment.generator.core.event.Event;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.util.EmailUtil;
import com.speedment.tool.core.brand.Palette;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.event.UIEvent;
import com.speedment.tool.core.resource.FontAwesome;
import com.speedment.tool.core.util.InjectionLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;

public final class MailPromptController
implements Initializable {
    private static final Pattern INVALID_MAIL = Pattern.compile("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,6}$");
    private static final Predicate<String> IS_INVALID_MAIL = mail -> !INVALID_MAIL.matcher((CharSequence)mail).find();
    @Inject
    public ProjectComponent projects;
    @Inject
    public UserInterfaceComponent ui;
    @Inject
    public InjectionLoader loader;
    @Inject
    public EventComponent events;
    @FXML
    private TextField email;
    @FXML
    private TextArea terms;
    @FXML
    private Button okay;

    public void initialize(URL location, ResourceBundle resources) {
        this.okay.setGraphic(FontAwesome.CHECK.view());
        this.okay.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> IS_INVALID_MAIL.test(this.email.getText()), (Observable[])new Observable[]{this.email.textProperty()}));
        this.okay.setOnAction(ev -> {
            this.loader.loadAndShow("Connect");
            if (EmailUtil.hasEmail()) {
                if (this.projects.getProject().dbmses().noneMatch(dbms -> true)) {
                    this.loader.loadAndShow("Connect");
                } else {
                    this.loader.loadAndShow("Scene");
                    this.ui.showNotification("Metadata has been loaded from an offline file. Click here to reload from database.", FontAwesome.REFRESH, Palette.INFO, this.ui::reload);
                }
            } else {
                this.loader.loadAndShow("MailPrompt");
            }
            EmailUtil.setEmail((String)this.email.getText());
            this.events.notify((Event)UIEvent.OPEN_CONNECT_WINDOW);
        });
        try {
            InputStream in = MailPromptController.class.getResourceAsStream("/text/terms.txt");
            String str = MailPromptController.inputToString(in);
            this.terms.setText(str);
        }
        catch (IOException ex) {
            this.ui.showError("Failed to load file", "The terms and conditions of this software couldn't be loaded.", ex);
        }
    }

    private static String inputToString(InputStream in) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(in);){
            String string;
            try (ByteArrayOutputStream buf = new ByteArrayOutputStream();){
                int result = bis.read();
                while (result != -1) {
                    byte b = (byte)result;
                    buf.write(b);
                    result = bis.read();
                }
                string = buf.toString();
            }
            return string;
        }
    }
}

