/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.internal.controller.NotificationController;
import com.speedment.tool.core.notification.Notification;
import com.speedment.tool.core.util.LayoutAnimator;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;

public final class NotificationAreaController
implements Initializable {
    private final LayoutAnimator animator = new LayoutAnimator();
    @Inject
    public UserInterfaceComponent userInterfaceComponent;
    @FXML
    private FlowPane notificationArea;

    public void initialize(URL url, ResourceBundle rb) {
        this.animator.observe((ObservableList<Node>)this.notificationArea.getChildren());
        ObservableList<Notification> notifications = this.userInterfaceComponent.notifications();
        notifications.addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(n -> {
                    NotificationController.showNotification(this.notificationArea, n.text(), n.icon(), n.palette(), n.onClose());
                    notifications.remove(n);
                });
            }
        });
        while (!notifications.isEmpty()) {
            Notification n = (Notification)notifications.get(0);
            NotificationController.showNotification(this.notificationArea, n.text(), n.icon(), n.palette(), n.onClose());
            notifications.remove(0);
        }
    }
}

