/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.tool.core.brand.Palette;
import com.speedment.tool.core.exception.SpeedmentToolException;
import com.speedment.tool.core.resource.Icon;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.util.Duration;

public final class NotificationController
implements Initializable {
    private static final int ENTER_SPEED = 350;
    private static final int EXIT_SPEED = 350;
    private static final int ENTER_Y = 100;
    private static final String NOTIFICATION_FXML = "/fxml/Notification.fxml";
    private static final Duration TIMER = Duration.seconds((double)10.0);
    private final String message;
    private final Icon icon;
    private final Palette palette;
    private final Runnable onClose;
    private final AtomicBoolean destroyed;
    @FXML
    private Label notification;

    private NotificationController(String message, Icon icon, Palette palette, Runnable onClose) {
        this.message = Objects.requireNonNull(message);
        this.icon = Objects.requireNonNull(icon);
        this.palette = Objects.requireNonNull(palette);
        this.onClose = Objects.requireNonNull(onClose);
        this.destroyed = new AtomicBoolean(false);
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.notification.setText(this.message);
        this.notification.setGraphic(this.icon.view());
        this.notification.getStyleClass().add((Object)this.palette.name().toLowerCase());
    }

    @FXML
    public void close() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.onClose.run();
            NotificationController.remove((Node)this.notification);
        }
    }

    private void fadeAway() {
        FadeTransition fade = new FadeTransition(Duration.millis((double)350.0), (Node)this.notification);
        fade.setFromValue(1.0);
        fade.setToValue(0.0);
        TranslateTransition trans = new TranslateTransition(Duration.millis((double)350.0), (Node)this.notification);
        trans.setFromY(0.0);
        trans.setToY(100.0);
        SequentialTransition seq = new SequentialTransition(new Animation[]{fade, trans});
        seq.setOnFinished(ev -> {
            if (this.destroyed.compareAndSet(false, true)) {
                NotificationController.remove((Node)this.notification);
            }
        });
        seq.play();
    }

    static void showNotification(FlowPane area, String message, Icon icon, Palette palette, Runnable onClose) {
        Node notification;
        FXMLLoader loader = new FXMLLoader(NotificationController.class.getResource(NOTIFICATION_FXML));
        AtomicReference ref = new AtomicReference();
        loader.setControllerFactory(clazz -> {
            ref.set(new NotificationController(message, icon, palette, onClose));
            return ref.get();
        });
        try {
            notification = (Node)loader.load();
        }
        catch (IOException ex) {
            throw new SpeedmentToolException("Failed to load FXML-file: '/fxml/Notification.fxml'.", ex);
        }
        notification.setOpacity(0.0);
        notification.setLayoutX(area.getWidth());
        notification.setLayoutY(area.getHeight());
        FadeTransition fade = new FadeTransition(Duration.millis((double)350.0), notification);
        fade.setFromValue(0.0);
        fade.setToValue(1.0);
        Platform.runLater(() -> {
            NotificationController.childrenOf((Node)area).add((Object)notification);
            fade.play();
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(TIMER, ev -> ((NotificationController)ref.get()).fadeAway(), new KeyValue[0])});
            timeline.play();
        });
    }

    private static void remove(Node node) {
        NotificationController.siblingsOf(node).remove((Object)node);
    }

    private static ObservableList<Node> siblingsOf(Node node) {
        Parent parent = node.getParent();
        if (parent == null) {
            throw new NullPointerException("Can't delete node from 'null' parent.");
        }
        return NotificationController.childrenOf((Node)parent);
    }

    private static ObservableList<Node> childrenOf(Node parent) {
        Method getChildren;
        try {
            getChildren = parent.getClass().getMethod("getChildren", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new SpeedmentToolException("Could not find public method 'getChildren()' in class '" + parent.getClass() + "'.", ex);
        }
        try {
            ObservableList siblings = (ObservableList)getChildren.invoke((Object)parent, new Object[0]);
            return siblings;
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new SpeedmentToolException("Error executing 'getChildren()' in class '" + parent.getClass() + "'.", ex);
        }
    }
}

