/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.resource.FontAwesome;
import com.speedment.tool.core.resource.MaterialIcon;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.VBox;

public final class OutputController
implements Initializable {
    @Inject
    public UserInterfaceComponent ui;
    @FXML
    private VBox log;
    @FXML
    private ScrollPane logPane;
    @FXML
    private ToggleButton wrapTextBtn;
    @FXML
    private ToggleButton scrollToEndBtn;
    @FXML
    private Button clearLogBtn;

    public void initialize(URL location, ResourceBundle resources) {
        Bindings.bindContent((List)this.log.getChildren(), this.ui.outputMessages());
        this.log.heightProperty().addListener(e -> {
            if (this.scrollToEndBtn.isSelected()) {
                this.scrollLogToEnd();
            }
        });
        this.logPane.fitToWidthProperty().bind((ObservableValue)this.wrapTextBtn.selectedProperty());
        this.scrollToEndBtn.setSelected(true);
        this.scrollToEndBtn.setOnAction(e -> {
            if (this.scrollToEndBtn.isSelected()) {
                this.scrollLogToEnd();
            }
        });
        this.clearLogBtn.setOnAction(ev -> this.ui.outputMessages().clear());
        this.clearLogBtn.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.log.getChildren()));
        this.styleToolbarButton((ButtonBase)this.wrapTextBtn, MaterialIcon.WRAP_TEXT.view());
        this.styleToolbarButton((ButtonBase)this.clearLogBtn, FontAwesome.TRASH.view());
        this.styleToolbarButton((ButtonBase)this.scrollToEndBtn, MaterialIcon.SCROLL_TEXT.view());
    }

    private void styleToolbarButton(ButtonBase btn, Node icon) {
        btn.setGraphic(icon);
        btn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    private void scrollLogToEnd() {
        this.logPane.setVvalue(1.0);
    }
}

