/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.tool.core.component.IssueComponent;
import com.speedment.tool.core.internal.util.ConfigFileHelper;
import com.speedment.tool.core.rule.Issue;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public final class ProjectProblemController
implements Initializable {
    @FXML
    private ListView<Issue> lstProjectProblems;
    @FXML
    private TextFlow txtDescription;
    @FXML
    private Button btnClose;
    @FXML
    private Button btnProceed;
    private final ObservableList<Issue> issues = FXCollections.observableArrayList();
    private final BooleanExpression hasErrors = Bindings.isNotEmpty((ObservableList)this.issues.filtered(issue -> issue.getLevel() == Issue.Level.ERROR));
    @Inject
    public ConfigFileHelper configFileHelper;
    @Inject
    public IssueComponent issueComponent;

    public void initialize(URL location, ResourceBundle resources) {
        Bindings.bindContent(this.issues, this.issueComponent.getIssues());
        this.lstProjectProblems.setItems(this.issues);
        this.lstProjectProblems.setCellFactory(this.listViewListCellCallback());
        this.lstProjectProblems.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            this.txtDescription.getChildren().clear();
            if (newValue != null) {
                this.txtDescription.getChildren().addAll((Object[])new Node[]{new Text(newValue.getDescription())});
            }
        });
        this.btnClose.setOnAction(ev -> this.closeWindow());
        this.btnProceed.setOnAction(ev -> this.closeWindowAndGenerate());
        this.btnProceed.disableProperty().bind((ObservableValue)this.hasErrors);
        this.btnProceed.sceneProperty().addListener(this.sceneChangeListener());
    }

    private ChangeListener<Scene> sceneChangeListener() {
        return (ov, oldVal, newVal) -> {
            if (oldVal == null && newVal != null) {
                Window window = (Window)newVal.windowProperty().get();
                if (window != null) {
                    window.setOnCloseRequest(ev -> this.closeWindow());
                } else {
                    newVal.windowProperty().addListener((ob, oldW, newW) -> newW.setOnCloseRequest(ev -> this.closeWindow()));
                }
            }
        };
    }

    private Callback<ListView<Issue>, ListCell<Issue>> listViewListCellCallback() {
        return param -> new ListCell<Issue>(){

            protected void updateItem(Issue item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText((Object)((Object)item.getLevel()) + " - " + item.getTitle());
                    Issue.Level i = item.getLevel();
                    if (i == Issue.Level.ERROR) {
                        this.setTextFill((Paint)Color.RED);
                    } else if (i == Issue.Level.WARNING) {
                        this.setTextFill((Paint)Color.DARKORANGE);
                    }
                } else {
                    this.setText("");
                }
            }
        };
    }

    private void closeWindowAndGenerate() {
        if (!this.configFileHelper.isFileOpen()) {
            this.configFileHelper.setCurrentlyOpenFile(new File("src/main/json/speedment.json"));
        }
        this.configFileHelper.saveCurrentlyOpenConfigFile();
        this.configFileHelper.generateSources();
        this.closeWindow();
    }

    private void closeWindow() {
        this.issueComponent.clear();
        Stage stage = (Stage)this.btnClose.getScene().getWindow();
        stage.close();
    }
}

