/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.generator.core.component.EventComponent;
import com.speedment.generator.core.event.Event;
import com.speedment.generator.core.event.ProjectLoaded;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.tool.actions.ProjectTreeComponent;
import com.speedment.tool.config.ColumnProperty;
import com.speedment.tool.config.DocumentProperty;
import com.speedment.tool.config.IndexProperty;
import com.speedment.tool.config.PrimaryKeyColumnProperty;
import com.speedment.tool.config.ProjectProperty;
import com.speedment.tool.config.trait.HasEnabledProperty;
import com.speedment.tool.config.trait.HasExpandedProperty;
import com.speedment.tool.config.trait.HasIconPath;
import com.speedment.tool.config.trait.HasNameProperty;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.resource.SpeedmentIcon;
import java.net.URL;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public final class ProjectTreeController
implements Initializable {
    @Inject
    public UserInterfaceComponent ui;
    @Inject
    public ProjectTreeComponent projectTreeComponent;
    @Inject
    public EventComponent events;
    @FXML
    private TreeView<DocumentProperty> hierarchy;

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> this.prepareTree(this.ui.projectProperty()));
    }

    private void prepareTree(ProjectProperty project) {
        Objects.requireNonNull(project);
        this.events.notify((Event)new ProjectLoaded((Project)project));
        Bindings.bindContent(this.ui.getSelectedTreeItems(), (ObservableList)this.hierarchy.getSelectionModel().getSelectedItems());
        this.hierarchy.setCellFactory(view -> new DocumentPropertyCell(this.projectTreeComponent));
        this.hierarchy.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.populateTree(project);
    }

    private void populateTree(ProjectProperty project) {
        Objects.requireNonNull(project);
        TreeItem<DocumentProperty> root = this.branch(project);
        this.hierarchy.setRoot(root);
        this.hierarchy.getSelectionModel().select(root);
    }

    private <P extends DocumentProperty & HasExpandedProperty> TreeItem<DocumentProperty> branch(P doc) {
        Objects.requireNonNull(doc);
        TreeItem branch = new TreeItem(doc);
        branch.expandedProperty().bindBidirectional((Property)((HasExpandedProperty)doc).expandedProperty());
        ListChangeListener onListChange = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().stream().filter(HasExpandedProperty.class::isInstance).map(d -> (HasExpandedProperty)d).map(this::branch).forEachOrdered(arg_0 -> branch.getChildren().add(arg_0));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(val -> branch.getChildren().removeIf(item -> val.equals(item.getValue())));
            }
        };
        doc.children().filter(HasExpandedProperty.class::isInstance).map(d -> (HasExpandedProperty)d).map(this::branch).forEachOrdered(arg_0 -> branch.getChildren().add(arg_0));
        doc.childrenProperty().addListener(change -> {
            if (change.wasAdded()) {
                ((ObservableList)change.getValueAdded()).addListener(onListChange);
                ((ObservableList)change.getValueAdded()).stream().filter(HasExpandedProperty.class::isInstance).map(d -> (HasExpandedProperty)d).map(x$0 -> this.branch(x$0)).forEachOrdered(arg_0 -> branch.getChildren().add(arg_0));
            }
        });
        doc.childrenProperty().values().forEach(list -> list.addListener(onListChange));
        return branch;
    }

    private static final class DocumentPropertyCell
    extends TreeCell<DocumentProperty> {
        private final ChangeListener<Boolean> change = (ob, o, enabled) -> {
            if (enabled.booleanValue()) {
                this.enable();
            } else {
                this.disable();
            }
        };
        private final ProjectTreeComponent projectTreeComponent;

        DocumentPropertyCell(ProjectTreeComponent projectTreeComponent) {
            this.projectTreeComponent = Objects.requireNonNull(projectTreeComponent);
            this.itemProperty().addListener((ob, o, n) -> {
                HasEnabledProperty hasEnabled;
                if (o instanceof HasEnabledProperty) {
                    hasEnabled = (HasEnabledProperty)o;
                    hasEnabled.enabledProperty().removeListener(this.change);
                }
                if (n instanceof HasEnabledProperty) {
                    hasEnabled = (HasEnabledProperty)n;
                    hasEnabled.enabledProperty().addListener(this.change);
                }
            });
        }

        private void disable() {
            this.getStyleClass().add((Object)"gui-disabled");
        }

        private void enable() {
            while (this.getStyleClass().remove((Object)"gui-disabled")) {
            }
        }

        protected void updateItem(DocumentProperty item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.textProperty().unbind();
                this.setText(null);
                this.setGraphic(null);
                this.setContextMenu(null);
                this.disable();
            } else {
                ImageView icon;
                if (item instanceof HasIconPath) {
                    HasIconPath hasIcon = (HasIconPath)item;
                    icon = new ImageView(new Image(hasIcon.getIconPath()));
                } else {
                    icon = SpeedmentIcon.forNode((Document)item);
                }
                this.setGraphic((Node)icon);
                if (item instanceof HasNameProperty) {
                    HasNameProperty withName = (HasNameProperty)item;
                    this.textProperty().bind((ObservableValue)withName.nameProperty());
                } else {
                    this.textProperty().unbind();
                    this.textProperty().setValue(null);
                }
                this.projectTreeComponent.createContextMenu((TreeCell)this, item).ifPresent(arg_0 -> ((DocumentPropertyCell)this).setContextMenu(arg_0));
                this.updateEnabled(item);
                this.getTreeView().refresh();
            }
        }

        private void updateEnabled(DocumentProperty item) {
            boolean indicateEnabled = HasEnabled.test((Document)item);
            if (item instanceof ColumnProperty) {
                indicateEnabled &= ((Table)((ColumnProperty)item).getParentOrThrow()).isEnabled();
            } else if (item instanceof IndexProperty) {
                indicateEnabled &= ((Table)((IndexProperty)item).getParentOrThrow()).isEnabled();
            } else if (item instanceof PrimaryKeyColumnProperty) {
                indicateEnabled &= ((Table)((PrimaryKeyColumnProperty)item).getParentOrThrow()).isEnabled();
            }
            if (indicateEnabled) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }
}

