/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.util.Statistics;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.component.VersionComponent;
import com.speedment.tool.core.internal.util.SemanticVersionComparator;
import com.speedment.tool.core.util.InjectionLoader;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.VBox;

public final class SceneController
implements Initializable {
    private static final Logger LOGGER = LoggerManager.getLogger(SceneController.class);
    private static final SemanticVersionComparator SEMANTIC_VERSION = new SemanticVersionComparator();
    @Inject
    public UserInterfaceComponent ui;
    @Inject
    public InfoComponent info;
    @Inject
    public InjectionLoader loader;
    @Inject
    public VersionComponent version;
    @Inject
    public ProjectComponent projects;
    @FXML
    private VBox top;
    @FXML
    private SplitPane horizontal;
    @FXML
    private SplitPane vertical;

    public void initialize(URL location, ResourceBundle resources) {
        this.top.getChildren().add((Object)this.loader.load("Menubar"));
        this.top.getChildren().add((Object)this.loader.load("Toolbar"));
        Node projectTree = this.loader.load("ProjectTree");
        Node workspace = this.loader.load("Workspace");
        Node output = this.loader.load("Output");
        this.horizontal.getItems().add(0, (Object)projectTree);
        this.vertical.getItems().add((Object)workspace);
        this.vertical.getItems().add((Object)output);
        this.ui.prepareProjectTree(this.horizontal, projectTree);
        this.ui.prepareWorkspace(this.vertical, workspace);
        this.ui.prepareOutput(this.vertical, output);
        this.horizontal.setDividerPositions(new double[]{0.3, 0.7});
        this.vertical.setDividerPositions(new double[]{0.7, 0.3});
        Statistics.report((InfoComponent)this.info, (ProjectComponent)this.projects, (Statistics.Event)Statistics.Event.GUI_PROJECT_LOADED);
        CompletableFuture.runAsync(() -> {
            try {
                ((CompletableFuture)this.version.latestVersion().thenAcceptAsync(release -> Platform.runLater(() -> {
                    int compare = SEMANTIC_VERSION.compare((String)release, this.info.getImplementationVersion());
                    if (compare == 0) {
                        this.ui.showNotification("Your version of " + this.info.getTitle() + " is up to date.");
                    } else if (compare > 0) {
                        this.ui.showNotification("A new version " + release + " of " + this.info.getTitle() + " is available.");
                    } else {
                        this.ui.showNotification("Your version " + this.info.getImplementationVersion() + " of " + this.info.getTitle() + " is newer than the released " + release + ".");
                    }
                }))).get(3L, TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                LOGGER.debug((Throwable)ex, "Error loading last released version.");
            }
            catch (InterruptedException ex) {
                LOGGER.debug((Throwable)ex, "Error loading last released version.");
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException ex) {
                LOGGER.debug((Throwable)ex, "Request for latest released version timed out.");
            }
        });
    }
}

