/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.controller;

import com.speedment.common.injector.annotation.Inject;
import com.speedment.generator.core.component.EventComponent;
import com.speedment.generator.core.event.Event;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.core.internal.util.Cast;
import com.speedment.tool.config.ColumnProperty;
import com.speedment.tool.config.DocumentProperty;
import com.speedment.tool.config.trait.HasNameProperty;
import com.speedment.tool.config.trait.HasTypeMapperProperty;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.event.TreeSelectionChange;
import com.speedment.tool.propertyeditor.PropertyEditor;
import com.speedment.tool.propertyeditor.PropertySheet;
import com.speedment.tool.propertyeditor.component.PropertyEditorComponent;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;

public final class WorkspaceController
implements Initializable {
    private final ObservableList<PropertyEditor.Item> properties = FXCollections.observableArrayList();
    @Inject
    public UserInterfaceComponent ui;
    @Inject
    public EventComponent events;
    @Inject
    public PropertyEditorComponent editors;
    @FXML
    private TitledPane workspace;
    @FXML
    private ScrollPane scrollpane;

    public void initialize(URL location, ResourceBundle resources) {
        PropertySheet sheet = new PropertySheet(this.properties);
        this.ui.getSelectedTreeItems().addListener(this.treeItemListChangeListener());
        this.scrollpane.setContent((Node)sheet);
        Bindings.bindContentBidirectional(this.ui.getProperties(), this.properties);
    }

    private ListChangeListener<TreeItem<DocumentProperty>> treeItemListChangeListener() {
        return change -> {
            TreeItem treeItem;
            this.properties.clear();
            if (!change.getList().isEmpty() && (treeItem = (TreeItem)change.getList().get(0)) != null) {
                DocumentProperty property = (DocumentProperty)treeItem.getValue();
                HasNameProperty withName = (HasNameProperty)property;
                String extraInfo = Cast.cast((Object)property, ColumnProperty.class).map(HasTypeMapperProperty::findDatabaseType).map(Class::getSimpleName).map(s -> "(" + s + ")").orElse("");
                this.workspace.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("Settings for database %s '%s' %s", this.type(withName), withName.getName(), extraInfo), (Observable[])new Observable[]{withName.nameProperty()}));
                this.editors.getUiVisibleProperties((DocumentProperty)treeItem.getValue()).forEachOrdered(arg_0 -> this.properties.add(arg_0));
            }
            ListChangeListener.Change changeCasted = change;
            this.events.notify((Event)new TreeSelectionChange((ListChangeListener.Change<TreeItem<DocumentProperty>>)changeCasted, this.properties));
        };
    }

    private String type(HasNameProperty withName) {
        if (withName instanceof Table) {
            return ((Table)withName).isView() ? "view" : "table";
        }
        return withName.mainInterface().getSimpleName().toLowerCase();
    }
}

