/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.menubar;

import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.InjectKey;
import com.speedment.common.injector.annotation.WithState;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.menubar.MenuBarComponent;
import com.speedment.tool.core.menubar.MenuBarTab;
import com.speedment.tool.core.resource.SpeedmentIcon;
import com.speedment.tool.core.util.InjectionLoader;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;

@InjectKey(value=DefaultMenuItemFactories.class)
public final class DefaultMenuItemFactories {
    @ExecuteBefore(value=State.INITIALIZED)
    public void install(@WithState(value=State.INITIALIZED) MenuBarComponent menuBar, @WithState(value=State.INITIALIZED) UserInterfaceComponent ui, @WithState(value=State.INITIALIZED) InjectionLoader loader) {
        menuBar.forTab(MenuBarTab.FILE).addMenuItem("_New", SpeedmentIcon.NEW_PROJECT, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.newProject())).addMenuItem("_Open", SpeedmentIcon.OPEN_PROJECT, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.openProject())).addSeparator().addMenuItem("_Save", SpeedmentIcon.DISK, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.saveProject())).addMenuItem("Save _As", SpeedmentIcon.DISK_MULTIPLE, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.saveProjectAs())).addSeparator().addMenuItem("_Quit", SpeedmentIcon.DOOR_IN, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.quit()));
        menuBar.forTab(MenuBarTab.EDIT).addMenuItem("_Generate", SpeedmentIcon.RUN_PROJECT, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.generate()));
        menuBar.forTab(MenuBarTab.WINDOW).set("project-tree", () -> {
            CheckMenuItem mi = new CheckMenuItem("_Project Tree");
            mi.setGraphic((Node)SpeedmentIcon.APPLICATION_SIDE_TREE.view());
            mi.selectedProperty().bindBidirectional((Property)ui.projectTreeVisibleProperty());
            return mi;
        }).set("workspace", () -> {
            CheckMenuItem mi = new CheckMenuItem("_Workspace");
            mi.setGraphic((Node)SpeedmentIcon.APPLICATION_FORM.view());
            mi.selectedProperty().bindBidirectional((Property)ui.workspaceVisibleProperty());
            return mi;
        }).set("output", () -> {
            CheckMenuItem mi = new CheckMenuItem("_Output");
            mi.setGraphic((Node)SpeedmentIcon.APPLICATION_XP_TERMINAL.view());
            mi.selectedProperty().bindBidirectional((Property)ui.outputVisibleProperty());
            return mi;
        });
        menuBar.forTab(MenuBarTab.HELP).addMenuItem("Online _Manual", SpeedmentIcon.BOOK, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.showManual())).addMenuItem("Online Help Chat on _Gitter", SpeedmentIcon.USER_COMMENT, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.showGitter())).addMenuItem("Report an _Issue", SpeedmentIcon.USER_COMMENT, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.reportIssue())).addMenuItem("Open the Git_Hub page", SpeedmentIcon.USER_COMMENT, (EventHandler<ActionEvent>)((EventHandler)ev -> ui.showGithub())).addSeparator().addMenuItem("_Components", SpeedmentIcon.BRICKS, (EventHandler<ActionEvent>)((EventHandler)ev -> loader.loadAsModal("Components"))).addSeparator().addMenuItem("_About", SpeedmentIcon.INFORMATION, (EventHandler<ActionEvent>)((EventHandler)ev -> loader.loadAsModal("About")));
    }
}

