/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.menubar;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.tool.core.internal.menubar.MenuBarTabHandlerImpl;
import com.speedment.tool.core.menubar.MenuBarComponent;
import com.speedment.tool.core.menubar.MenuBarTab;
import com.speedment.tool.core.menubar.MenuBarTabHandler;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;

public final class MenuBarComponentImpl
implements MenuBarComponent {
    private final Map<MenuBarTab, MenuBarTabHandler> handlers = new EnumMap<MenuBarTab, MenuBarTabHandler>(MenuBarTab.class);

    @ExecuteBefore(value=State.INITIALIZED)
    public void populateHandlers(Injector injector) {
        for (MenuBarTab tab : MenuBarTab.values()) {
            this.handlers.put(tab, new MenuBarTabHandlerImpl(injector));
        }
    }

    @Override
    public MenuBarTabHandler forTab(MenuBarTab tab) {
        return Objects.requireNonNull(this.handlers.get((Object)tab));
    }

    @Override
    public void populate(MenuBar menuBar) {
        ObservableList menus = menuBar.getMenus();
        menus.clear();
        for (Map.Entry<MenuBarTab, MenuBarTabHandler> e : this.handlers.entrySet()) {
            Menu menu = new Menu(e.getKey().getText());
            e.getValue().populate(menu);
            if (menu.getItems().isEmpty()) continue;
            menus.add((Object)menu);
        }
    }
}

