/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.menubar;

import com.speedment.common.injector.Injector;
import com.speedment.tool.core.menubar.MenuBarTabHandler;
import com.speedment.tool.core.menubar.MenuItemFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.control.Menu;

public class MenuBarTabHandlerImpl
implements MenuBarTabHandler {
    private final Map<String, MenuItemFactory> byKey;
    private final List<MenuItemFactory> factories;
    private final Injector injector;

    MenuBarTabHandlerImpl(Injector injector) {
        this.injector = Objects.requireNonNull(injector);
        this.byKey = new HashMap<String, MenuItemFactory>();
        this.factories = new ArrayList<MenuItemFactory>();
    }

    @Override
    public MenuBarTabHandler add(MenuItemFactory factory) {
        this.factories.add((MenuItemFactory)this.injector.inject((Object)factory));
        return this;
    }

    @Override
    public MenuBarTabHandler set(String key, MenuItemFactory factory) {
        this.injector.inject((Object)factory);
        MenuItemFactory oldFactory = this.byKey.put(key, factory);
        if (oldFactory == null) {
            this.factories.add(factory);
        } else {
            this.factories.set(this.factories.indexOf(oldFactory), factory);
        }
        return this;
    }

    @Override
    public MenuBarTabHandler insert(int index, MenuItemFactory factory) {
        this.factories.add(index, (MenuItemFactory)this.injector.inject((Object)factory));
        return this;
    }

    @Override
    public boolean remove(String key) {
        MenuItemFactory oldFactory = this.byKey.remove(key);
        if (oldFactory == null) {
            return false;
        }
        this.factories.remove(oldFactory);
        return true;
    }

    @Override
    public int indexOf(String key) {
        MenuItemFactory factory = this.byKey.get(key);
        if (factory == null) {
            return -1;
        }
        return this.factories.indexOf(factory);
    }

    @Override
    public void populate(Menu menu) {
        ObservableList items = menu.getItems();
        items.clear();
        for (MenuItemFactory factory : this.factories) {
            items.add((Object)factory.createMenuItem());
        }
    }
}

