/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.rule;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.trait.HasAlias;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.tool.core.component.IssueComponent;
import com.speedment.tool.core.rule.Issue;
import com.speedment.tool.core.rule.Rule;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class ProtectedNameRule
implements Rule {
    private static final String[] PROTECTED_NAMES = new String[]{"AbstractEntity", "AbstractApplicationMetadata", "AbstractSqlManager", "Boolean", "Char", "Class", "ComparableField", "ComparableFieldImpl", "Double", "Field", "FieldIdentifier", "Float", "Integer", "Identifier", "Injector", "Long", "Optional", "Object", "OptionalUtil", "ProjectComponent", "ResultSet", "String", "StringField", "StringFieldImpl", "SqlManager", "Stream", "StringBuilder", "SQLException", "SpeedmentException", "StringJoiner", "Table", "TypeMapper", "Tuple", "Tuples"};
    private final Pattern pattern;
    private final ProjectComponent projectComponent;
    private final IssueComponent issues;

    public ProtectedNameRule(ProjectComponent projectComponent, IssueComponent issues) {
        this.projectComponent = Objects.requireNonNull(projectComponent);
        this.issues = Objects.requireNonNull(issues);
        this.pattern = Pattern.compile(String.join((CharSequence)"|", PROTECTED_NAMES), 2);
    }

    @Override
    public CompletableFuture<Boolean> verify() {
        return CompletableFuture.supplyAsync(this::checkRule);
    }

    private boolean checkRule() {
        AtomicBoolean noIssues = new AtomicBoolean(true);
        Project project = this.projectComponent.getProject();
        DocumentDbUtil.traverseOver((Project)project).filter(DocumentDbUtil::isAllAncestorsEnabled).forEach(doc -> this.check((Document)doc, noIssues));
        return noIssues.get();
    }

    private void check(Document document, AtomicBoolean noIssues) {
        HasAlias alias = HasAlias.of((Document)document);
        final String docName = alias.getJavaName();
        if (this.pattern.matcher(docName).matches()) {
            noIssues.set(false);
            this.issues.post(new Issue(){

                @Override
                public String getTitle() {
                    return "Protected Name: " + docName;
                }

                @Override
                public String getDescription() {
                    return "The Type name " + docName + " is used internally by Speedment. If this name is assigned to a generated entiry, it might cause conflicts in the generated code.\nYou may still proceed with code generation, but please be aware that the generated code might contain errors. To fix this issue, rename the entity in question.";
                }

                @Override
                public Issue.Level getLevel() {
                    return Issue.Level.WARNING;
                }
            });
        }
    }
}

