/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.rule;

import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.trait.HasColumn;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.tool.core.component.IssueComponent;
import com.speedment.tool.core.rule.Issue;
import com.speedment.tool.core.rule.Rule;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ReferencesEnabledRule
implements Rule {
    private final ProjectComponent projectComponent;
    private final IssueComponent issues;

    public ReferencesEnabledRule(ProjectComponent projectComponent, IssueComponent issues) {
        this.projectComponent = Objects.requireNonNull(projectComponent);
        this.issues = Objects.requireNonNull(issues);
    }

    @Override
    public CompletableFuture<Boolean> verify() {
        return CompletableFuture.supplyAsync(this::checkRule);
    }

    private boolean checkRule() {
        AtomicBoolean noIssues = new AtomicBoolean(true);
        Project project = this.projectComponent.getProject();
        DocumentDbUtil.traverseOver((Project)project).filter(DocumentDbUtil::isAllAncestorsEnabled).forEach(doc -> this.check((Document)doc, noIssues));
        return noIssues.get();
    }

    private void check(Document document, AtomicBoolean noIssues) {
        if (document instanceof HasColumn) {
            HasColumn source = (HasColumn)document;
            Optional target = source.findColumn();
            final String sourceName = this.nameOf((HasName)source);
            if (target.isPresent()) {
                final Column col = (Column)target.get();
                if (!col.isEnabled()) {
                    noIssues.set(false);
                    final String targetName = this.nameOf((HasName)target.get());
                    this.issues.post(new Issue(){

                        @Override
                        public String getTitle() {
                            return "Reference not enabled: " + col.getId();
                        }

                        @Override
                        public String getDescription() {
                            return "The referenced element " + col.getId() + ", is not enabled. Disabled elements will not be generated. Thus, referencing a disabled element will result in broken code.\nThis might be a result of the element in question not being enabled, or that an ancestor of the element is not enabled. \nTo fix this issue, make sure the element " + targetName + " is enabled.";
                        }

                        @Override
                        public Issue.Level getLevel() {
                            return Issue.Level.ERROR;
                        }
                    });
                }
            } else {
                this.issues.post(new Issue(){

                    @Override
                    public String getTitle() {
                        return "Referenced column does not exist";
                    }

                    @Override
                    public String getDescription() {
                        return "'" + sourceName + "' references a column that does not exist. Make sure the name of it corresponds to the name of the referenced column in the database.";
                    }

                    @Override
                    public Issue.Level getLevel() {
                        return Issue.Level.ERROR;
                    }
                });
            }
        }
    }

    private String nameOf(HasName doc) {
        return DocumentUtil.relativeName((Document)doc, Project.class, (DocumentUtil.Name)DocumentUtil.Name.DATABASE_NAME);
    }
}

