/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.toolbar;

import com.speedment.common.codegen.model.File;
import com.speedment.generator.core.component.EventComponent;
import com.speedment.generator.core.event.AfterGenerate;
import com.speedment.generator.core.event.BeforeGenerate;
import com.speedment.generator.core.event.FileGenerated;
import com.speedment.tool.core.toolbar.ToolbarItem;
import com.speedment.tool.core.toolbar.ToolbarSide;
import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.control.Label;

public final class GenerationProgressToolbarItem
implements ToolbarItem<Label> {
    private final EventComponent events;

    public GenerationProgressToolbarItem(EventComponent events) {
        this.events = Objects.requireNonNull(events);
    }

    @Override
    public Label createNode() {
        Label label = new Label("");
        this.events.on(BeforeGenerate.class, bg -> Platform.runLater(() -> label.setText("Generating...")));
        this.events.on(FileGenerated.class, fg -> Platform.runLater(() -> label.setText(((File)fg.meta().getModel()).getName())));
        this.events.on(AfterGenerate.class, ag -> Platform.runLater(() -> label.setText("")));
        return label;
    }

    @Override
    public ToolbarSide getSide() {
        return ToolbarSide.LEFT;
    }
}

