/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.toolbar;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.tool.core.toolbar.ToolbarComponent;
import com.speedment.tool.core.toolbar.ToolbarItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public final class ToolbarComponentImpl
implements ToolbarComponent {
    private final Map<String, ToolbarItem<?>> byKey = new HashMap();
    private final List<ToolbarItem<?>> leftSide = new ArrayList();
    private final List<ToolbarItem<?>> rightSide = new ArrayList();
    private Injector injector;

    @ExecuteBefore(value=State.INITIALIZED)
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector);
    }

    @Override
    public void install(ToolbarItem<Button> item) {
        this.install(((Button)((ToolbarItem)this.injector.inject(item)).createNode()).getText(), item);
    }

    @Override
    public <T extends Node> void install(String key, ToolbarItem<T> item) {
        block9: {
            ToolbarItem<T> oldItem;
            block8: {
                this.injector.inject(item);
                oldItem = this.byKey.put(key, item);
                if (oldItem != null) break block8;
                switch (item.getSide()) {
                    case LEFT: {
                        this.leftSide.add(item);
                        break block9;
                    }
                    case RIGHT: {
                        this.rightSide.add(item);
                        break block9;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unknown enum constant '%s'.", new Object[]{item.getSide()}));
                    }
                }
            }
            switch (oldItem.getSide()) {
                case LEFT: {
                    this.leftSide.set(this.leftSide.indexOf(oldItem), item);
                    break;
                }
                case RIGHT: {
                    this.rightSide.set(this.rightSide.indexOf(oldItem), item);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown enum constant '%s'.", new Object[]{item.getSide()}));
                }
            }
        }
    }

    @Override
    public void populate(Pane parent) {
        ObservableList children = parent.getChildren();
        children.clear();
        this.leftSide.stream().map(ToolbarItem::createNode).forEachOrdered(arg_0 -> children.add(arg_0));
        Pane separator = new Pane();
        separator.setPrefHeight(1.0);
        HBox.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
        children.add((Object)separator);
        ListIterator<ToolbarItem<?>> it = this.rightSide.listIterator(this.rightSide.size());
        while (it.hasPrevious()) {
            children.add(it.previous().createNode());
        }
    }
}

