/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.util;

import java.lang.reflect.Array;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;

public final class CompletableFutureUtil {
    private CompletableFutureUtil() {
    }

    @SafeVarargs
    public static <T> CompletableFuture<T> allOf(T defaultValue, BinaryOperator<T> merger, CompletableFuture<T> ... futures) {
        CompletableFuture[] accumulators = (CompletableFuture[])Array.newInstance(CompletableFuture.class, futures.length);
        AtomicReference result = new AtomicReference(defaultValue);
        for (int i = 0; i < futures.length; ++i) {
            CompletableFuture<T> future = futures[i];
            accumulators[i] = future.thenAcceptAsync(r -> result.accumulateAndGet(r, merger));
        }
        return CompletableFuture.allOf(accumulators).thenApplyAsync(v -> result.get());
    }
}

