/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.util;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Config;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.InjectKey;
import com.speedment.common.json.Json;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.generator.translator.TranslatorManager;
import com.speedment.runtime.application.provider.DefaultApplicationBuilder;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.mutator.ProjectMutator;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.util.DocumentTranscoder;
import com.speedment.runtime.core.Speedment;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.runtime.core.component.PasswordComponent;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.db.DbmsMetadataHandler;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.util.ProgressMeasure;
import com.speedment.runtime.typemapper.TypeMapper;
import com.speedment.tool.config.DbmsProperty;
import com.speedment.tool.config.ProjectProperty;
import com.speedment.tool.config.component.DocumentPropertyComponent;
import com.speedment.tool.core.MainApp;
import com.speedment.tool.core.brand.Palette;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.exception.SpeedmentToolException;
import com.speedment.tool.core.resource.FontAwesome;
import com.speedment.tool.core.util.OutputUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

@InjectKey(value=ConfigFileHelper.class)
public final class ConfigFileHelper {
    private static final Logger LOGGER = LoggerManager.getLogger(ConfigFileHelper.class);
    private static final String DOT_JSON = ".json";
    public static final String DEFAULT_CONFIG_LOCATION = "src/main/json/speedment.json";
    private static final Predicate<File> OPEN_FILE_CONDITIONS = file -> file != null && file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(DOT_JSON);
    private final DocumentPropertyComponent documentPropertyComponent;
    private final DbmsHandlerComponent dbmsHandlerComponent;
    private final PasswordComponent passwordComponent;
    private final TranslatorManager translatorManager;
    private final ProjectComponent projectComponent;
    private final InfoComponent infoComponent;
    private UserInterfaceComponent userInterfaceComponent;
    private Injector injector;
    private File currentlyOpenFile;

    public ConfigFileHelper(DocumentPropertyComponent documentPropertyComponent, DbmsHandlerComponent dbmsHandlerComponent, PasswordComponent passwordComponent, TranslatorManager translatorManager, ProjectComponent projectComponent, InfoComponent infoComponent, @Config(name="metadata_location", value="src/main/json/speedment.json") File currentlyOpenFile) {
        this.documentPropertyComponent = Objects.requireNonNull(documentPropertyComponent);
        this.dbmsHandlerComponent = Objects.requireNonNull(dbmsHandlerComponent);
        this.passwordComponent = Objects.requireNonNull(passwordComponent);
        this.translatorManager = Objects.requireNonNull(translatorManager);
        this.projectComponent = Objects.requireNonNull(projectComponent);
        this.infoComponent = Objects.requireNonNull(infoComponent);
        this.currentlyOpenFile = Objects.requireNonNull(currentlyOpenFile);
    }

    @ExecuteBefore(value=State.INITIALIZED)
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector);
    }

    @ExecuteBefore(value=State.INITIALIZED)
    public void setUserInterfaceComponent(UserInterfaceComponent userInterfaceComponent) {
        this.userInterfaceComponent = Objects.requireNonNull(userInterfaceComponent);
    }

    public boolean isFileOpen() {
        return this.currentlyOpenFile != null;
    }

    public File getCurrentlyOpenFile() {
        return this.currentlyOpenFile;
    }

    public void setCurrentlyOpenFile(File currentlyOpenFile) {
        this.currentlyOpenFile = currentlyOpenFile;
    }

    public void loadFromDatabaseAndSaveToFile() {
        ProjectProperty project = new ProjectProperty();
        Project loaded = this.projectComponent.getProject();
        if (loaded == null) {
            throw new SpeedmentToolException("Can't load from database unless either a dbms and schema is specified or a config file is present.");
        }
        project.merge(this.documentPropertyComponent, loaded);
        Project projectCopy = Project.createImmutable((Project)project);
        project.dbmses().map(dbms -> {
            DbmsType dbmsType = (DbmsType)this.dbmsHandlerComponent.findByName(dbms.getTypeName()).orElseThrow(() -> new SpeedmentToolException("Could not find dbms type with name '" + dbms.getTypeName() + "'."));
            Object[] objectArray = new Object[3];
            objectArray[0] = dbms.getName();
            objectArray[1] = dbms.getIpAddress().orElse("127.0.0.1");
            objectArray[2] = dbms.getPort().orElseGet(() -> ((DbmsType)dbmsType).getDefaultPort());
            LOGGER.info(String.format("Reloading from dbms '%s' on %s:%d.", objectArray));
            Set schemaNames = dbms.schemas().map(HasName::getName).collect(Collectors.toSet());
            Predicate<String> schemaFilter = schemaNames.isEmpty() ? s -> true : schemaNames::contains;
            return dbmsType.getMetadataHandler().readSchemaMetadata(dbms, ProgressMeasure.create(), schemaFilter);
        }).forEachOrdered(fut -> {
            try {
                Project newProject = (Project)fut.join();
                ProjectProperty projectProperty = project;
                synchronized (projectProperty) {
                    this.setTypeMappersFrom(newProject, projectCopy);
                    project.merge(this.documentPropertyComponent, newProject);
                }
            }
            catch (CancellationException ex) {
                throw new SpeedmentToolException("Cancellation in execution of reload sequence.", ex);
            }
            catch (CompletionException ex) {
                throw new SpeedmentToolException("Reload sequence completed with exception.", ex);
            }
        });
        this.saveConfigFile(this.currentlyOpenFile == null ? new File(DEFAULT_CONFIG_LOCATION) : this.currentlyOpenFile, project, false);
    }

    public boolean loadFromDatabase(DbmsProperty dbms, String schemaName) {
        Runnable restore = () -> {
            this.passwordComponent.put((Dbms)dbms, null);
            this.userInterfaceComponent.projectProperty().observableListOf("dbmses").remove((Object)dbms);
        };
        try {
            Project projectCopy = Project.createImmutable((Project)this.userInterfaceComponent.projectProperty());
            this.projectComponent.setProject(projectCopy);
            ConcurrentSkipListMap dbmsData = new ConcurrentSkipListMap(dbms.getData());
            dbmsData.remove("schemas");
            Dbms dbmsCopy = Dbms.create((Project)((Project)dbms.getParentOrThrow()), dbmsData);
            DbmsMetadataHandler dh = this.dbmsHandlerComponent.findByName(dbmsCopy.getTypeName()).map(DbmsType::getMetadataHandler).orElseThrow(() -> new SpeedmentToolException("Could not find metadata handler for DbmsType '" + dbmsCopy.getTypeName() + "'."));
            ProgressMeasure progress = ProgressMeasure.create();
            CompletionStage future = dh.readSchemaMetadata(dbmsCopy, progress, schemaName::equalsIgnoreCase).handleAsync((p, ex) -> {
                progress.setProgress(1.0);
                if (ex == null && p != null) {
                    dbms.schemasProperty().clear();
                    this.setTypeMappersFrom((Project)p, projectCopy);
                    this.userInterfaceComponent.projectProperty().merge(this.documentPropertyComponent, p);
                    return true;
                }
                restore.run();
                Platform.runLater(() -> this.userInterfaceComponent.showError("Error Connecting to Database", "A problem occured with establishing the database connection.", (Throwable)ex));
                return false;
            });
            this.userInterfaceComponent.showProgressDialog("Loading Database Metadata", progress, (CompletableFuture<Boolean>)future);
            boolean status = (Boolean)((CompletableFuture)future).join();
            if (status) {
                this.userInterfaceComponent.showNotification("Database metadata has been loaded.", FontAwesome.DATABASE, Palette.INFO);
            } else {
                restore.run();
            }
            return status;
        }
        catch (CancellationException | CompletionException ex2) {
            restore.run();
            this.userInterfaceComponent.showError("Error Executing Connection Task", "The execution of certain tasks could not be completed.", ex2);
            return false;
        }
    }

    private void setTypeMappersFrom(Project to, Project from) {
        from.dbmses().forEach(dbms -> dbms.schemas().forEach(schema -> schema.tables().forEach(table -> table.columns().filter(c -> c.getTypeMapper().isPresent()).forEach(column -> {
            String mapperName = (String)column.getTypeMapper().get();
            try {
                Class<?> mapperClass = Class.forName(mapperName);
                this.setTypeMapper(to, (Dbms)dbms, (Schema)schema, (Table)table, (Column)column, (Class<? extends TypeMapper<?, ?>>)mapperClass);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new IllegalStateException("Unable to find mapper class " + mapperName);
            }
        }))));
    }

    private void setTypeMapper(Project to, Dbms dbms, Schema schema, Table table, Column column, Class<? extends TypeMapper<?, ?>> typeMapperClass) {
        to.dbmses().filter(d -> d.getId().equals(dbms.getId())).flatMap(Dbms::schemas).filter(s -> s.getId().equals(schema.getId())).flatMap(Schema::tables).filter(t -> t.getId().equals(table.getId())).flatMap(Table::columns).filter(c -> c.getId().equals(column.getId())).filter(c -> c.getDatabaseType().equals(column.getDatabaseType())).forEach(c -> c.mutator().setTypeMapper(typeMapperClass));
    }

    public void loadConfigFile(File file, UserInterfaceComponent.ReuseStage reuse) {
        if (OPEN_FILE_CONDITIONS.test(file)) {
            try {
                switch (reuse) {
                    case CREATE_A_NEW_STAGE: {
                        Stage newStage = new Stage();
                        InjectorBuilder injectorBuilder = this.injector.newBuilder().withParam("metadata_location", DEFAULT_CONFIG_LOCATION);
                        Speedment newSpeedment = new DefaultApplicationBuilder(injectorBuilder).build();
                        MainApp.setInjector((Injector)newSpeedment.getOrThrow(Injector.class));
                        MainApp main = new MainApp();
                        try {
                            main.start(newStage);
                            break;
                        }
                        catch (Exception ex) {
                            throw new SpeedmentToolException(ex);
                        }
                    }
                    case USE_EXISTING_STAGE: {
                        Project p = DocumentTranscoder.load((Path)file.toPath(), this::fromJson);
                        this.userInterfaceComponent.projectProperty().merge(this.documentPropertyComponent, p);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown enum constant '" + (Object)((Object)reuse) + "'.");
                    }
                }
                this.currentlyOpenFile = file;
            }
            catch (SpeedmentToolException ex) {
                LOGGER.error((Throwable)ex);
                this.userInterfaceComponent.log(OutputUtil.error(ex.getMessage()));
                this.userInterfaceComponent.showError("Could not load project", ex.getMessage(), ex);
            }
        } else {
            this.userInterfaceComponent.showError("Could not read .json file", "The file '" + file.getAbsoluteFile().getName() + "' could not be read.", null);
        }
    }

    private Map<String, Object> fromJson(String json) {
        Map parsed = (Map)Json.fromJson((String)json);
        return parsed;
    }

    public void saveConfigFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save JSON File");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("JSON files (*.json)", new String[]{"*.json"}));
        if (this.currentlyOpenFile == null) {
            Path path = Paths.get(DEFAULT_CONFIG_LOCATION, new String[0]);
            Path parent = path.getParent();
            if (parent == null) {
                throw new SpeedmentToolException("Unable to save " + path.toString() + " (no parent).");
            }
            try {
                if (!parent.toFile().exists()) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fileChooser.setInitialDirectory(parent.toFile());
            fileChooser.setInitialFileName(Optional.ofNullable(path.getFileName()).map(Path::toString).orElse(""));
        } else {
            fileChooser.setInitialDirectory(this.currentlyOpenFile.getParentFile());
            fileChooser.setInitialFileName(this.currentlyOpenFile.getName());
        }
        File file = fileChooser.showSaveDialog((Window)this.userInterfaceComponent.getStage());
        if (file != null) {
            if (!file.getName().endsWith(DOT_JSON)) {
                file = new File(file.getAbsolutePath() + DOT_JSON);
            }
            this.saveConfigFile(file);
        }
    }

    public void saveCurrentlyOpenConfigFile() {
        this.saveConfigFile(this.currentlyOpenFile);
    }

    private void saveConfigFile(File file) {
        this.saveConfigFile(file, this.userInterfaceComponent.projectProperty(), true);
    }

    private void saveConfigFile(File file, ProjectProperty project, boolean isGraphical) {
        Path path = file.toPath();
        Path parent = path.getParent();
        if (parent == null) {
            throw new SpeedmentToolException("Unable to save " + file.toString() + " (no parent).");
        }
        try {
            if (!parent.toFile().exists()) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            project.stringPropertyOf("speedmentVersion", () -> null).setValue(this.infoComponent.getEditionAndVersionString());
            DocumentTranscoder.save((Project)project, (Path)path, Json::toJson);
            if (isGraphical) {
                String absolute = file.getAbsolutePath();
                this.userInterfaceComponent.log(OutputUtil.success("Saved project file to '" + absolute + "'."));
                this.userInterfaceComponent.showNotification("Configuration saved.", FontAwesome.DOWNLOAD, Palette.INFO);
            }
            this.currentlyOpenFile = file;
        }
        catch (IOException ex) {
            if (isGraphical) {
                this.userInterfaceComponent.showError("Could not save file", ex.getMessage(), ex);
            }
            throw new SpeedmentToolException(ex);
        }
    }

    public void generateSources() {
        try {
            this.translatorManager.accept(this.projectComponent.getProject());
            Platform.runLater(() -> {
                this.userInterfaceComponent.log(OutputUtil.success("+------------: Generation completed! :------------+\n| Files generated  " + this.alignRight("" + this.translatorManager.getFilesCreated(), 41) + " |\n+-------------------------------------------------+"));
                this.userInterfaceComponent.showNotification("Generation completed! " + this.translatorManager.getFilesCreated() + " files created.", FontAwesome.STAR, Palette.SUCCESS);
            });
        }
        catch (Exception ex) {
            Platform.runLater(() -> {
                this.userInterfaceComponent.log(OutputUtil.error("+--------------: Generation failed! :-------------+\n| Files generated  " + this.alignRight("" + this.translatorManager.getFilesCreated(), 41) + " |\n| Exception Type   " + this.alignRight(ex.getClass().getSimpleName(), 41) + " |\n+-------------------------------------------------+"));
                String msg = "Error! Failed to generate code. A " + ex.getClass().getSimpleName() + " was thrown.";
                LOGGER.error((Throwable)ex, msg);
                this.userInterfaceComponent.showError("Failed to generate code", ex.getMessage(), ex);
            });
        }
    }

    private String alignRight(String substring, int totalWidth) {
        String formatString = "%" + totalWidth + "s";
        return String.format(formatString, substring);
    }

    public void clearTablesAndSaveToFile() {
        ProjectMutator projectMutator = Project.deepCopy((Project)DocumentTranscoder.load((Path)this.currentlyOpenFile.toPath(), this::fromJson)).mutator();
        projectMutator.setSpeedmentVersion(this.infoComponent.getEditionAndVersionString());
        Project project = (Project)projectMutator.document();
        LOGGER.info("clearing tables");
        project.dbmses().forEach(dbms -> {
            LOGGER.info("dbms: " + dbms.getName());
            dbms.schemas().forEach(schema -> {
                LOGGER.info("schema: " + schema.getName());
                if (schema.getData().containsKey("tables")) {
                    LOGGER.info("Removing " + schema.tables().count());
                    schema.getData().remove("tables");
                } else {
                    LOGGER.info("No tables to remove");
                }
            });
        });
        if (this.currentlyOpenFile.isFile()) {
            if (this.currentlyOpenFile.exists() && !this.currentlyOpenFile.delete()) {
                this.userInterfaceComponent.log(OutputUtil.warning("Unable to delete " + this.currentlyOpenFile));
            }
        } else {
            throw new SpeedmentToolException(this.currentlyOpenFile.toPath() + " is not a file");
        }
        DocumentTranscoder.save((Project)project, (Path)this.currentlyOpenFile.toPath(), Json::toJson);
    }

    public void saveProjectToCurrentlyOpenFile(ProjectProperty project) {
        this.saveConfigFile(this.getCurrentlyOpenFile(), project, false);
    }
}

