/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.util;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.MissingArgumentStrategy;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.mapstream.MapStream;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.tool.core.brand.Brand;
import com.speedment.tool.core.component.UserInterfaceComponent;
import com.speedment.tool.core.exception.SpeedmentToolException;
import com.speedment.tool.core.internal.controller.AboutController;
import com.speedment.tool.core.internal.controller.ComponentsController;
import com.speedment.tool.core.internal.controller.ConnectController;
import com.speedment.tool.core.internal.controller.MailPromptController;
import com.speedment.tool.core.internal.controller.MenubarController;
import com.speedment.tool.core.internal.controller.NotificationAreaController;
import com.speedment.tool.core.internal.controller.OutputController;
import com.speedment.tool.core.internal.controller.ProjectProblemController;
import com.speedment.tool.core.internal.controller.ProjectTreeController;
import com.speedment.tool.core.internal.controller.SceneController;
import com.speedment.tool.core.internal.controller.ToolbarController;
import com.speedment.tool.core.internal.controller.WorkspaceController;
import com.speedment.tool.core.internal.util.WindowSettingUtil;
import com.speedment.tool.core.util.BrandUtil;
import com.speedment.tool.core.util.InjectionLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class InjectionLoaderImpl
implements InjectionLoader {
    private static final String FXML_PREFIX = "/fxml/";
    private static final String FXML_SUFFIX = ".fxml";
    private final Map<Class<?>, Supplier<? extends Initializable>> constructors;
    private final InfoComponent infoComponent;
    private final Brand brand;
    private UserInterfaceComponent userInterfaceComponent;
    private Injector injector;

    public InjectionLoaderImpl(InfoComponent infoComponent, Brand brand) {
        this.infoComponent = Objects.requireNonNull(infoComponent);
        this.brand = Objects.requireNonNull(brand);
        this.constructors = new ConcurrentHashMap();
    }

    @ExecuteBefore(value=State.INITIALIZED, missingArgument=MissingArgumentStrategy.SKIP_INVOCATION)
    public void setUserInterfaceComponent(UserInterfaceComponent userInterfaceComponent) {
        this.userInterfaceComponent = Objects.requireNonNull(userInterfaceComponent);
    }

    @ExecuteBefore(value=State.INITIALIZED)
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector);
    }

    @ExecuteBefore(value=State.INITIALIZED)
    public void installConstructors() {
        this.constructors.put(AboutController.class, AboutController::new);
        this.constructors.put(ComponentsController.class, ComponentsController::new);
        this.constructors.put(ConnectController.class, ConnectController::new);
        this.constructors.put(MailPromptController.class, MailPromptController::new);
        this.constructors.put(MenubarController.class, MenubarController::new);
        this.constructors.put(NotificationAreaController.class, NotificationAreaController::new);
        this.constructors.put(OutputController.class, OutputController::new);
        this.constructors.put(ProjectTreeController.class, ProjectTreeController::new);
        this.constructors.put(SceneController.class, SceneController::new);
        this.constructors.put(ToolbarController.class, ToolbarController::new);
        this.constructors.put(WorkspaceController.class, WorkspaceController::new);
        this.constructors.put(ProjectProblemController.class, ProjectProblemController::new);
    }

    public FXMLLoader fxmlLoader() {
        FXMLLoader loader = new FXMLLoader(StandardCharsets.UTF_8);
        loader.setControllerFactory(clazz -> MapStream.of(this.constructors).filterKey(clazz::isAssignableFrom).values().findFirst().map(Supplier::get).map(arg_0 -> ((Injector)this.injector).inject(arg_0)).orElseThrow(() -> new SpeedmentToolException("FXML Controller '" + clazz.getName() + "' have not been installed in " + this.getClass().getSimpleName() + ".")));
        return loader;
    }

    @Override
    public <T extends Initializable> void install(Class<T> controllerClass, Supplier<T> newController) {
        this.constructors.put(controllerClass, newController);
    }

    @Override
    public Node load(String name) {
        FXMLLoader loader = this.fxmlLoader();
        String filename = FXML_PREFIX + name + FXML_SUFFIX;
        loader.setLocation(InjectionLoaderImpl.class.getResource(filename));
        try {
            return (Node)loader.load();
        }
        catch (IOException ex) {
            throw new SpeedmentToolException("Error! Could not find FXML-file: " + filename + ".", ex);
        }
    }

    @Override
    public Parent loadAndShow(String name) {
        Parent parent = (Parent)this.load(name);
        Stage stage = Objects.requireNonNull(this.userInterfaceComponent.getStage());
        Scene scene = new Scene(parent);
        stage.hide();
        BrandUtil.applyBrand(this.injector, stage, scene);
        stage.setScene(scene);
        WindowSettingUtil.applySaveOnCloseMethod(stage, name);
        if ("Scene".equals(name)) {
            WindowSettingUtil.applyStoredDisplaySettings(stage, name);
        }
        stage.show();
        return parent;
    }

    @Override
    public Parent loadAsModal(String name) {
        Stage mainStage = Objects.requireNonNull(this.userInterfaceComponent.getStage());
        Stage dialog = new Stage();
        Parent root = (Parent)this.load(name);
        Scene scene = new Scene(root);
        BrandUtil.applyBrandToScene(this.injector, scene);
        dialog.setTitle("About " + this.infoComponent.getTitle());
        dialog.initModality(Modality.APPLICATION_MODAL);
        this.brand.logoSmall().map(Image::new).ifPresent(arg_0 -> dialog.getIcons().add(arg_0));
        dialog.initOwner((Window)mainStage);
        dialog.setScene(scene);
        dialog.show();
        return root;
    }
}

