/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.util;

import java.util.Comparator;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SemanticVersionComparator
implements Comparator<String> {
    private static final Pattern NUMERIC = Pattern.compile("^[0-9]+$");

    @Override
    public int compare(String first, String second) {
        if (first == null || second == null) {
            return first == null ? 1 : -1;
        }
        String[] firstWords = first.split("(\\.|-)");
        String[] secondWords = second.split("(\\.|-)");
        for (int i = 0; i < Math.min(firstWords.length, secondWords.length); ++i) {
            OptionalInt j = this.compareWords(firstWords[i], secondWords[i]);
            if (!j.isPresent()) continue;
            return j.getAsInt();
        }
        if (firstWords.length < secondWords.length) {
            return 1;
        }
        if (firstWords.length > secondWords.length) {
            return -1;
        }
        return 0;
    }

    private OptionalInt compareWords(String firstWord, String secondWord) {
        if (firstWord.equals(secondWord)) {
            return OptionalInt.empty();
        }
        if ("SNAPSHOT".equals(firstWord)) {
            return OptionalInt.of(-1);
        }
        if ("SNAPSHOT".equals(secondWord)) {
            return OptionalInt.of(1);
        }
        if ("RELEASE".equals(firstWord)) {
            return OptionalInt.of(1);
        }
        if ("RELEASE".equals(secondWord)) {
            return OptionalInt.of(-1);
        }
        if ("EA".equals(firstWord)) {
            return OptionalInt.of(1);
        }
        if ("EA".equals(secondWord)) {
            return OptionalInt.of(-1);
        }
        OptionalInt c = this.compareNonNumericChars(firstWord, secondWord);
        return c.isPresent() ? c : OptionalInt.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OptionalInt compareNonNumericChars(String firstWord, String secondWord) {
        Matcher fn = NUMERIC.matcher(firstWord);
        Matcher sn = NUMERIC.matcher(secondWord);
        if (fn.find()) {
            int s;
            if (!sn.find()) return OptionalInt.of(firstWord.compareTo(secondWord));
            int f = Integer.parseInt(fn.group());
            int c = Integer.compare(f, s = Integer.parseInt(sn.group()));
            if (c == 0) return OptionalInt.empty();
            return OptionalInt.of(c);
        }
        if (sn.find()) {
            return OptionalInt.of(firstWord.compareTo(secondWord));
        }
        int c = firstWord.compareTo(secondWord);
        if (c == 0) return OptionalInt.empty();
        return OptionalInt.of(c);
    }
}

