/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class Throttler {
    private final ConcurrentHashMap<String, AtomicLong> timers;
    private final long millis;

    public static Throttler limitToOnceEvery(long millis) {
        return new Throttler(millis);
    }

    private Throttler(long millis) {
        this.millis = millis;
        this.timers = new ConcurrentHashMap();
    }

    public void call(String action, Runnable runnable) {
        AtomicLong timer;
        long now = Throttler.now();
        if (now == (timer = this.timers.computeIfAbsent(action, a -> new AtomicLong(0L))).updateAndGet(lastCall -> lastCall + this.millis < now ? now : lastCall)) {
            runnable.run();
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }
}

