/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.internal.util;

import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.stage.Stage;

final class WindowSettingUtil {
    private static final Logger LOGGER = LoggerManager.getLogger(WindowSettingUtil.class);
    private static final Preferences PREFERENCES = Preferences.userNodeForPackage(WindowSettingUtil.class);
    private static final String WINDOW_WIDTH = "windowWidth";
    private static final String WINDOW_HEIGHT = "windowHeight";
    private static final String WINDOW_X_POS = "windowXPos";
    private static final String WINDOW_Y_POS = "windowYPos";
    private static final String WINDOW_MAXIMIZED = "windowMaximized";
    private static final double DEFUALT_WIDTH = 1280.0;
    private static final double DEFUALT_HEIHGT = 720.0;
    private static final double DEFUALT_X = 0.0;
    private static final double DEFUALT_Y = 0.0;

    private WindowSettingUtil() {
    }

    static void applyStoredDisplaySettings(Stage stage, String name) {
        try {
            if (PREFERENCES.nodeExists(name)) {
                Preferences stagePreferences = PREFERENCES.node(name);
                boolean wasMaximized = stagePreferences.getBoolean(WINDOW_MAXIMIZED, false);
                if (wasMaximized) {
                    stage.setMaximized(true);
                } else {
                    stage.setX(stagePreferences.getDouble(WINDOW_X_POS, 0.0));
                    stage.setY(stagePreferences.getDouble(WINDOW_Y_POS, 0.0));
                    stage.setWidth(stagePreferences.getDouble(WINDOW_WIDTH, 1280.0));
                    stage.setHeight(stagePreferences.getDouble(WINDOW_HEIGHT, 720.0));
                }
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.error((Throwable)ex, "Could not access preferences for window " + name);
        }
    }

    static void applySaveOnCloseMethod(Stage stage, String name) {
        stage.setOnCloseRequest(ev -> {
            try {
                Preferences stagePreferences = PREFERENCES.node(name);
                if (stage.isMaximized()) {
                    stagePreferences.putBoolean(WINDOW_MAXIMIZED, true);
                } else {
                    stagePreferences.putBoolean(WINDOW_MAXIMIZED, false);
                    stagePreferences.putDouble(WINDOW_X_POS, stage.getX());
                    stagePreferences.putDouble(WINDOW_Y_POS, stage.getY());
                    stagePreferences.putDouble(WINDOW_WIDTH, stage.getWidth());
                    stagePreferences.putDouble(WINDOW_HEIGHT, stage.getHeight());
                }
                stagePreferences.flush();
            }
            catch (BackingStoreException ex) {
                LOGGER.error((Throwable)ex, "Could not flush preferences for window " + name);
            }
        });
    }
}

