/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.resource;

import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.ForeignKeyColumn;
import com.speedment.runtime.config.Index;
import com.speedment.runtime.config.IndexColumn;
import com.speedment.runtime.config.PrimaryKeyColumn;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.runtime.core.exception.SpeedmentException;
import com.speedment.tool.config.trait.HasIconPath;
import com.speedment.tool.core.resource.Icon;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public enum SpeedmentIcon implements Icon
{
    BIG_GENERATE("/images/icon-generate.png"),
    BIG_CONFIGURE("/images/icon-configure.png"),
    BIG_GENERATE_HOVER("/images/icon-generate-hover.png"),
    BIG_CONFIGURE_HOVER("/images/icon-configure-hover.png"),
    NEW_PROJECT("/pics/vectors_rendered/newProject.png"),
    NEW_PROJECT_24("/pics/vectors_rendered/newProject24.png"),
    OPEN_PROJECT("/pics/vectors_rendered/openProject.png"),
    OPEN_PROJECT_24("/pics/vectors_rendered/openProject24.png"),
    RUN_PROJECT("/pics/vectors_rendered/runProject.png"),
    RUN_PROJECT_24("/pics/vectors_rendered/runProject24.png"),
    COLUMN("/pics/vectors_rendered/column.png"),
    DBMS("/pics/vectors_rendered/buildingKey.png"),
    FOREIGN_KEY("/pics/vectors_rendered/foreignKey.png"),
    FOREIGN_KEY_COLUMN("/pics/vectors_rendered/foreignKeyColumn.png"),
    INDEX("/pics/vectors_rendered/index.png"),
    INDEX_COLUMN("/pics/vectors_rendered/indexColumn.png"),
    PRIMARY_KEY("/pics/vectors_rendered/tableKey.png"),
    PRIMARY_KEY_COLUMN("/pics/vectors_rendered/primaryKeyColumn.png"),
    PROJECT("/pics/vectors_rendered/project.png"),
    SCHEMA("/pics/vectors_rendered/schema.png"),
    TABLE("/pics/vectors_rendered/table.png"),
    TABLE_LINK("/pics/vectors_rendered/tableLink.png"),
    PLUGIN_DATA("/pics/vectors_rendered/plugin.png"),
    ADD_DBMS_TRANS("/pics/dialog/add_dbms_trans.png"),
    OPEN_FILE("/pics/dialog/openFile.png"),
    SPEEDMENT_LOGO("/pics/dialog/speedment_logo.png"),
    SPEEDMENT_LOGO_100("/pics/dialog/speedment_logo100.png"),
    WALKING_MAN("/pics/dialog/walking_man.gif"),
    WALKING_MAN_SMALL("/pics/dialog/walking_man_small.png"),
    SPIRE("/images/logo.png"),
    SITEMAP_COLOR("/pics/vectors_rendered/sitemapColor.png"),
    BOX("/pics/vectors_rendered/box.png"),
    BRICKS("/pics/vectors_rendered/bricks.png"),
    BOOK("/pics/vectors_rendered/book.png"),
    BOOK_OPEN("/pics/vectors_rendered/bookOpen.png"),
    BOOK_NEXT("/pics/vectors_rendered/bookNext.png"),
    DATABASE_CONNECT("/pics/vectors_rendered/databaseConnect.png"),
    DATABASE("/pics/vectors_rendered/database.png"),
    PAGE_WHITE_CUP("/pics/vectors_rendered/pageWhiteCup.png"),
    CUP("/pics/vectors_rendered/cup.png"),
    TEXT_SIGNATURE("/pics/vectors_rendered/textSignature.png"),
    BOOK_LINK("/pics/vectors_rendered/bookLink.png"),
    DISK("/pics/vectors_rendered/disk.png"),
    DISK_MULTIPLE("/pics/vectors_rendered/diskMultiple.png"),
    DOOR_IN("/pics/vectors_rendered/doorIn.png"),
    APPLICATION_SIDE_TREE("/pics/vectors_rendered/applicationSideTree.png"),
    APPLICATION_FORM("/pics/vectors_rendered/applicationForm.png"),
    APPLICATION_XP_TERMINAL("/pics/vectors_rendered/applicationXpTerminal.png"),
    USER_COMMENT("/pics/vectors_rendered/userComment.png"),
    INFORMATION("/pics/vectors_rendered/info.png"),
    HELP("/pics/vectors_rendered/help.png"),
    SCRIPT_ADD("/pics/vectors_rendered/scriptAdd.png"),
    SCRIPT_DELETE("/pics/vectors_rendered/scriptDelete.png"),
    DATABASE_MONO("/pics/vectors_rendered/mono-database.png"),
    DISK_MONO("/pics/vectors_rendered/mono-disk2.png"),
    EXCLAMATION_MONO("/pics/vectors_rendered/mono-exclamation.png"),
    REFRESH_MONO("/pics/vectors_rendered/mono-fa-refresh.png"),
    FOLDER_OPEN_MONO("/pics/vectors_rendered/mono-folder-open.png"),
    LOCK_MONO("/pics/vectors_rendered/mono-lock.png"),
    PLAY_CIRCLE_MONO("/pics/vectors_rendered/mono-play-circle.png"),
    SIGN_IN_MONO("/pics/vectors_rendered/mono-sign-in.png"),
    SPINNER_MONO("/pics/vectors_rendered/mono-spinner.png"),
    TIMES_MONO("/pics/vectors_rendered/mono-times.png");

    private final String filename;
    private static final Logger LOGGER;
    private static final Map<Class<?>, SpeedmentIcon> NODE_ICONS;

    public Image load() {
        return new Image(this.getFileInputStream());
    }

    public ImageView view() {
        return new ImageView(this.load());
    }

    public static ImageView forNode(Document node) {
        SpeedmentIcon icon;
        Objects.requireNonNull(node);
        Optional<String> path = Optional.of(node).filter(HasIconPath.class::isInstance).map(HasIconPath.class::cast).map(HasIconPath::getIconPath);
        if (path.isPresent()) {
            InputStream stream = SpeedmentIcon.class.getResourceAsStream(path.get());
            if (stream != null) {
                return new ImageView(new Image(stream));
            }
            LOGGER.error("Config node '" + node.getClass().getSimpleName() + "' specified a custom icon '" + path.get() + "' that could not be loaded.");
        }
        if ((icon = node instanceof Table ? (((Table)node).isView() ? TABLE_LINK : TABLE) : NODE_ICONS.get(Optional.of(node).filter(HasMainInterface.class::isInstance).map(HasMainInterface.class::cast).map(HasMainInterface::mainInterface).orElse(null))) != null) {
            return icon.view();
        }
        LOGGER.error("Found no predefined icon for node type '" + node.getClass().getSimpleName() + "'.");
        return HELP.view();
    }

    private SpeedmentIcon(String filename) {
        this.filename = Objects.requireNonNull(filename);
    }

    private InputStream getFileInputStream() {
        InputStream stream = this.getClass().getResourceAsStream(this.filename);
        if (stream == null) {
            throw new SpeedmentException("Could not find icon: '" + this.filename + "'.");
        }
        return stream;
    }

    public String getFilename() {
        return this.filename;
    }

    static {
        LOGGER = LoggerManager.getLogger(SpeedmentIcon.class);
        HashMap<Class, SpeedmentIcon> map = new HashMap<Class, SpeedmentIcon>();
        map.put(Dbms.class, DBMS);
        map.put(Schema.class, SCHEMA);
        map.put(Table.class, TABLE);
        map.put(Column.class, COLUMN);
        map.put(Index.class, INDEX);
        map.put(IndexColumn.class, INDEX_COLUMN);
        map.put(ForeignKey.class, FOREIGN_KEY);
        map.put(ForeignKeyColumn.class, FOREIGN_KEY_COLUMN);
        map.put(PrimaryKeyColumn.class, PRIMARY_KEY_COLUMN);
        map.put(Project.class, PROJECT);
        NODE_ICONS = Collections.unmodifiableMap(map);
    }
}

