/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.util;

import com.speedment.common.injector.Injector;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.tool.core.brand.Brand;
import com.speedment.tool.core.component.UserInterfaceComponent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public final class BrandUtil {
    private BrandUtil() {
    }

    public static void applyBrand(Injector injector, Stage stage) {
        BrandUtil.applyBrand(injector, stage, stage.getScene());
    }

    public static void applyBrand(Injector injector, Stage stage, Scene scene) {
        BrandUtil.applyBrandToStage(injector, stage);
        Brand brand = (Brand)injector.getOrThrow(Brand.class);
        InfoComponent info = (InfoComponent)injector.getOrThrow(InfoComponent.class);
        BrandUtil.apply(brand, info, stage, scene);
    }

    public static void applyBrandToStage(Injector injector, Stage stage) {
        InfoComponent info = (InfoComponent)injector.getOrThrow(InfoComponent.class);
        Brand brand = (Brand)injector.getOrThrow(Brand.class);
        stage.setTitle(info.getTitle());
        brand.logoSmall().map(Image::new).ifPresent(arg_0 -> stage.getIcons().add(arg_0));
    }

    public static void applyBrandToScene(Injector injector, Scene scene) {
        Brand brand = (Brand)injector.getOrThrow(Brand.class);
        UserInterfaceComponent ui = (UserInterfaceComponent)injector.getOrThrow(UserInterfaceComponent.class);
        InfoComponent info = (InfoComponent)injector.getOrThrow(InfoComponent.class);
        Stage stage = scene.getWindow() == null ? ui.getStage() : (Stage)scene.getWindow();
        BrandUtil.apply(brand, info, stage, scene);
    }

    private static void apply(Brand brand, InfoComponent info, Stage stage, Scene scene) {
        if (stage != null) {
            stage.setTitle(info.getTitle());
        }
        brand.logoSmall().map(Image::new).ifPresent(icon -> {
            Stage dialogStage;
            if (stage != null) {
                stage.getIcons().add(icon);
            }
            if ((dialogStage = (Stage)scene.getWindow()) != null) {
                dialogStage.getIcons().add(icon);
            }
        });
        brand.stylesheets().forEachOrdered(arg_0 -> scene.getStylesheets().add(arg_0));
    }
}

