/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.core.util;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.Duration;

public final class LayoutAnimator
implements ChangeListener<Number>,
ListChangeListener<Node> {
    private final Map<Node, TranslateTransition> nodeXTransitions = new HashMap<Node, TranslateTransition>();
    private final Map<Node, TranslateTransition> nodeYTransitions = new HashMap<Node, TranslateTransition>();

    public void observe(ObservableList<Node> nodes) {
        nodes.forEach(this::observe);
        nodes.addListener((ListChangeListener)this);
    }

    public void unobserve(ObservableList<Node> nodes) {
        nodes.removeListener((ListChangeListener)this);
    }

    private void observe(Node n) {
        n.layoutXProperty().addListener((ChangeListener)this);
        n.layoutYProperty().addListener((ChangeListener)this);
    }

    private void unobserve(Node n) {
        n.layoutXProperty().removeListener((ChangeListener)this);
        n.layoutYProperty().removeListener((ChangeListener)this);
    }

    public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
        TranslateTransition t;
        double delta = newValue.doubleValue() - oldValue.doubleValue();
        DoubleProperty doubleProperty = (DoubleProperty)ov;
        Node node = (Node)doubleProperty.getBean();
        if (doubleProperty.getName().equals("layoutX")) {
            t = this.nodeXTransitions.get(node);
            if (t == null) {
                t = new TranslateTransition(Duration.millis((double)150.0), node);
                t.setToX(0.0);
                this.nodeXTransitions.put(node, t);
            }
            t.setFromX(node.getTranslateX() - delta);
            node.setTranslateX(node.getTranslateX() - delta);
        } else {
            t = this.nodeYTransitions.get(node);
            if (t == null) {
                t = new TranslateTransition(Duration.millis((double)150.0), node);
                t.setToY(0.0);
                this.nodeYTransitions.put(node, t);
            }
            t.setFromY(node.getTranslateY() - delta);
            node.setTranslateY(node.getTranslateY() - delta);
        }
        t.playFromStart();
    }

    public void onChanged(ListChangeListener.Change<? extends Node> change) {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::observe);
                continue;
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(this::unobserve);
        }
    }
}

