/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.std;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonToken;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Collection;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _collectionType;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;
    protected final Boolean _unwrapSingle;

    public StringCollectionDeserializer(JavaType collectionType, JsonDeserializer<?> valueDeser, ValueInstantiator valueInstantiator) {
        this(collectionType, valueInstantiator, null, valueDeser, null);
    }

    protected StringCollectionDeserializer(JavaType collectionType, ValueInstantiator valueInstantiator, JsonDeserializer<?> delegateDeser, JsonDeserializer<?> valueDeser, Boolean unwrapSingle) {
        super(collectionType);
        this._collectionType = collectionType;
        this._valueDeserializer = valueDeser;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = delegateDeser;
        this._unwrapSingle = unwrapSingle;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer<?> delegateDeser, JsonDeserializer<?> valueDeser, Boolean unwrapSingle) {
        if (this._unwrapSingle == unwrapSingle && this._valueDeserializer == valueDeser && this._delegateDeserializer == delegateDeser) {
            return this;
        }
        return new StringCollectionDeserializer(this._collectionType, this._valueInstantiator, delegateDeser, valueDeser, unwrapSingle);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        AnnotatedWithParams delegateCreator;
        JsonDeserializer<Object> delegate = null;
        if (this._valueInstantiator != null && (delegateCreator = this._valueInstantiator.getDelegateCreator()) != null) {
            JavaType delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
            delegate = this.findDeserializer(ctxt, delegateType, property);
        }
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        JavaType valueType = this._collectionType.getContentType();
        if (valueDeser == null) {
            if ((valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser)) == null) {
                valueDeser = ctxt.findContextualValueDeserializer(valueType, property);
            }
        } else {
            valueDeser = ctxt.handleSecondaryContextualization(valueDeser, property, valueType);
        }
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (this.isDefaultDeserializer(valueDeser)) {
            valueDeser = null;
        }
        return this.withResolved(delegate, valueDeser, unwrapSingle);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        return deser;
    }

    @Override
    public Collection<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        Collection result = (Collection)this._valueInstantiator.createUsingDefault(ctxt);
        return this.deserialize(p, ctxt, result);
    }

    @Override
    public Collection<String> deserialize(JsonParser p, DeserializationContext ctxt, Collection<String> result) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            return this.handleNonArray(p, ctxt, result);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(p, ctxt, result, this._valueDeserializer);
        }
        try {
            while (true) {
                String value;
                if ((value = p.nextTextValue()) != null) {
                    result.add(value);
                    continue;
                }
                JsonToken t = p.getCurrentToken();
                if (t != JsonToken.END_ARRAY) {
                    if (t != JsonToken.VALUE_NULL) {
                        value = this._parseString(p, ctxt);
                    }
                    result.add(value);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, result, result.size());
        }
        return result;
    }

    private Collection<String> deserializeUsingCustom(JsonParser p, DeserializationContext ctxt, Collection<String> result, JsonDeserializer<String> deser) throws IOException {
        while (true) {
            String value;
            if (p.nextTextValue() == null) {
                JsonToken t = p.getCurrentToken();
                if (t == JsonToken.END_ARRAY) break;
                value = t == JsonToken.VALUE_NULL ? deser.getNullValue(ctxt) : deser.deserialize(p, ctxt);
            } else {
                value = deser.deserialize(p, ctxt);
            }
            result.add(value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p, ctxt);
    }

    private final Collection<String> handleNonArray(JsonParser p, DeserializationContext ctxt, Collection<String> result) throws IOException {
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!canWrap) {
            return (Collection)ctxt.handleUnexpectedToken(this._collectionType.getRawClass(), p);
        }
        JsonDeserializer<String> valueDes = this._valueDeserializer;
        JsonToken t = p.getCurrentToken();
        String value = t == JsonToken.VALUE_NULL ? (valueDes == null ? null : valueDes.getNullValue(ctxt)) : (valueDes == null ? this._parseString(p, ctxt) : valueDes.deserialize(p, ctxt));
        result.add(value);
        return result;
    }
}

