/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.io.File;
import java.util.HashMap;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenRegistryAuthSupplier
implements RegistryAuthSupplier {
    private static final Logger log = LoggerFactory.getLogger(MavenRegistryAuthSupplier.class);
    private final Settings settings;

    public MavenRegistryAuthSupplier(Settings settings) {
        this.settings = settings;
    }

    public RegistryAuth authFor(String imageName) throws DockerException {
        ImageRef ref = new ImageRef(imageName);
        Server server = this.settings.getServer(ref.getRegistryName());
        if (server != null) {
            String password = server.getPassword();
            boolean encrypted = false;
            try {
                encrypted = MavenRegistryAuthSupplier.isEncrypted(password);
            }
            catch (PlexusCipherException e) {
                log.warn("Couldn't determine if Maven server password is encrypted.");
                log.warn("Assuming Maven server password *is not* encrypted.", (Throwable)e);
            }
            try {
                log.debug("Maven server password is encrypted: {}", (Object)encrypted);
                if (encrypted) {
                    password = this.decryptPassword(password);
                    log.debug("Successfully decrypted Maven server password");
                }
            }
            catch (PlexusCipherException | SecDispatcherException e) {
                throw new DockerException("Failed to decrypt Maven server password", e);
            }
            return RegistryAuth.builder().username(server.getUsername()).password(password).build();
        }
        log.warn("Did not find maven server configuration for docker server " + ref.getRegistryName());
        return null;
    }

    public RegistryAuth authForSwarm() throws DockerException {
        return null;
    }

    public RegistryConfigs authForBuild() throws DockerException {
        HashMap<String, RegistryAuth> allConfigs = new HashMap<String, RegistryAuth>();
        for (Server server : this.settings.getServers()) {
            allConfigs.put(server.getId(), RegistryAuth.builder().username(server.getUsername()).password(server.getPassword()).build());
        }
        return RegistryConfigs.create(allConfigs);
    }

    private String decryptPassword(String encryptedPassword) throws PlexusCipherException, SecDispatcherException {
        String location = System.getProperty("settings.security", "~/.m2/settings-security.xml");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0, (Object)"Location of settings-security.xml must not be empty");
        String realLocation = location.charAt(0) == '~' ? System.getProperty("user.home") + location.substring(1) : location;
        log.debug("Using location of '{}' for settings-security.xml", (Object)new File(realLocation).getAbsolutePath());
        SettingsSecurity settingsSecurity = SecUtil.read((String)realLocation, (boolean)true);
        String encryptedMasterPassword = settingsSecurity.getMaster();
        String decryptedMasterPassword = MavenRegistryAuthSupplier.decryptPassword(encryptedMasterPassword, "settings.security");
        return MavenRegistryAuthSupplier.decryptPassword(encryptedPassword, decryptedMasterPassword);
    }

    private static String decryptPassword(String encryptedPassword, String passPhrase) throws PlexusCipherException {
        DefaultPlexusCipher cipher = new DefaultPlexusCipher();
        return cipher.decryptDecorated(encryptedPassword, passPhrase);
    }

    private static boolean isEncrypted(String password) throws PlexusCipherException {
        DefaultPlexusCipher cipher = new DefaultPlexusCipher();
        return cipher.isEncryptedString(password);
    }
}

