/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.logging;

import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.Platform;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public final class HttpLoggingInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Logger logger;
    private volatile Level level = Level.NONE;

    public HttpLoggingInterceptor() {
        this(Logger.DEFAULT);
    }

    public HttpLoggingInterceptor(Logger logger) {
        this.logger = logger;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Level level = this.level;
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = level == Level.BODY;
        boolean logHeaders = logBody || level == Level.HEADERS;
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.getProtocol() : Protocol.HTTP_1_1;
        String requestStartMessage = "--> " + request.method() + ' ' + HttpLoggingInterceptor.requestPath(request.httpUrl()) + ' ' + HttpLoggingInterceptor.protocol(protocol);
        if (!logHeaders && hasRequestBody) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.logger.log(requestStartMessage);
        if (logHeaders) {
            Headers headers = request.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                this.logger.log(headers.name(i) + ": " + headers.value(i));
            }
            String endMessage = "--> END " + request.method();
            if (logBody && hasRequestBody) {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = UTF8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    contentType.charset(UTF8);
                }
                this.logger.log("");
                this.logger.log(buffer.readString(charset));
                endMessage = endMessage + " (" + requestBody.contentLength() + "-byte body)";
            }
            this.logger.log(endMessage);
        }
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        this.logger.log("<-- " + HttpLoggingInterceptor.protocol(response.protocol()) + ' ' + response.code() + ' ' + response.message() + " (" + tookMs + "ms" + (!logHeaders ? ", " + responseBody.contentLength() + "-byte body" : "") + ')');
        if (logHeaders) {
            Headers headers = response.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                this.logger.log(headers.name(i) + ": " + headers.value(i));
            }
            String endMessage = "<-- END HTTP";
            if (logBody) {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                Charset charset = UTF8;
                MediaType contentType = responseBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                if (responseBody.contentLength() != 0L) {
                    this.logger.log("");
                    this.logger.log(buffer.clone().readString(charset));
                }
                endMessage = endMessage + " (" + buffer.size() + "-byte body)";
            }
            this.logger.log(endMessage);
        }
        return response;
    }

    private static String protocol(Protocol protocol) {
        return protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1";
    }

    private static String requestPath(HttpUrl url) {
        String path = url.encodedPath();
        String query = url.encodedQuery();
        return query != null ? path + '?' + query : path;
    }

    public static interface Logger {
        public static final Logger DEFAULT = new Logger(){

            @Override
            public void log(String message) {
                Platform.get().log(message);
            }
        };

        public void log(String var1);
    }

    public static enum Level {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

