/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiRequestBodyConverter;
import retrofit2.converter.moshi.MoshiResponseBodyConverter;

public final class MoshiConverterFactory
extends Converter.Factory {
    private final Moshi moshi;
    private final boolean lenient;

    public static MoshiConverterFactory create() {
        return MoshiConverterFactory.create(new Moshi.Builder().build());
    }

    public static MoshiConverterFactory create(Moshi moshi) {
        return new MoshiConverterFactory(moshi, false);
    }

    private MoshiConverterFactory(Moshi moshi, boolean lenient) {
        if (moshi == null) {
            throw new NullPointerException("moshi == null");
        }
        this.moshi = moshi;
        this.lenient = lenient;
    }

    public MoshiConverterFactory asLenient() {
        return new MoshiConverterFactory(this.moshi, true);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JsonAdapter adapter = this.moshi.adapter(type);
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        return new MoshiResponseBodyConverter(adapter);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JsonAdapter adapter = this.moshi.adapter(type);
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        return new MoshiRequestBodyConverter(adapter);
    }
}

