/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/schema/CoreLoader;", "Lcom/squareup/wire/schema/Loader;", "()V", "ANY_PROTO", "", "DESCRIPTOR_PROTO", "WIRE_EXTENSIONS_PROTO", "load", "Lcom/squareup/wire/schema/ProtoFile;", "path", "wire-schema"})
public final class CoreLoader
implements Loader {
    @NotNull
    public static final String ANY_PROTO = "google/protobuf/any.proto";
    @NotNull
    public static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    @NotNull
    public static final String WIRE_EXTENSIONS_PROTO = "wire/extensions.proto";
    public static final CoreLoader INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProtoFile load(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (Intrinsics.areEqual((Object)path, (Object)ANY_PROTO) || Intrinsics.areEqual((Object)path, (Object)DESCRIPTOR_PROTO) || Intrinsics.areEqual((Object)path, (Object)WIRE_EXTENSIONS_PROTO)) {
            InputStream resourceAsStream;
            InputStream inputStream = resourceAsStream = SchemaLoader.class.getResourceAsStream('/' + path);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"resourceAsStream");
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((InputStream)inputStream));
            boolean bl = false;
            Throwable throwable = null;
            try {
                BufferedSource source = (BufferedSource)closeable;
                boolean bl2 = false;
                String data = source.readUtf8();
                Location location = Location.Companion.get(path);
                ProtoFileElement element = ProtoParser.Companion.parse(location, data);
                ProtoFile protoFile = ProtoFile.Companion.get(element);
                return protoFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        String string = "unexpected load: " + path;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private CoreLoader() {
    }

    static {
        CoreLoader coreLoader;
        INSTANCE = coreLoader = new CoreLoader();
    }
}

