/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.UtilJVMKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0003J\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010!2\u0006\u0010\"\u001a\u00020\u0001H\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00010\nj\b\u0012\u0004\u0012\u00020\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/squareup/wire/schema/Pruner;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "pruningRules", "Lcom/squareup/wire/schema/PruningRules;", "(Lcom/squareup/wire/schema/Schema;Lcom/squareup/wire/schema/PruningRules;)V", "marks", "Lcom/squareup/wire/schema/MarkSet;", "queue", "Ljava/util/Queue;", "Lcom/squareup/wire/schema/internal/MutableQueue;", "addOptions", "", "options", "", "Lcom/squareup/wire/schema/ProtoMember;", "result", "", "isRetainedVersion", "", "protoMember", "markReachable", "markRoots", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "protoType", "Lcom/squareup/wire/schema/ProtoType;", "markRootsIncludingNested", "type", "Lcom/squareup/wire/schema/Type;", "prune", "reachableObjects", "", "root", "retainAll", "retainImports", "protoFiles", "wire-schema"})
public final class Pruner {
    private final MarkSet marks;
    private final Queue<Object> queue;
    private final Schema schema;
    private final PruningRules pruningRules;

    @NotNull
    public final Schema prune() {
        this.markRoots();
        this.markReachable();
        List<ProtoFile> retained = this.retainImports(this.retainAll(this.schema, this.marks));
        return new Schema((Iterable<ProtoFile>)retained);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProtoFile> retainAll(Schema schema, MarkSet marks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = schema.getProtoFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void protoFile;
            ProtoFile protoFile2 = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProtoFile protoFile3 = protoFile.retainAll(schema, marks);
            collection.add(protoFile3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProtoFile> retainImports(List<ProtoFile> protoFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = protoFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void protoFile;
            ProtoFile protoFile2 = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProtoFile protoFile3 = protoFile.retainImports(protoFiles);
            collection.add(protoFile3);
        }
        return (List)destination$iv$iv;
    }

    private final void markRoots() {
        for (ProtoFile protoFile : this.schema.getProtoFiles()) {
            this.markRoots(protoFile);
        }
    }

    private final void markRoots(ProtoFile protoFile) {
        for (Type type : protoFile.getTypes()) {
            this.markRootsIncludingNested(type);
        }
        for (Service service : protoFile.getServices()) {
            this.markRoots(service.type());
        }
    }

    private final void markRootsIncludingNested(Type type) {
        this.markRoots(type.getType());
        for (Type nested : type.getNestedTypes()) {
            this.markRootsIncludingNested(nested);
        }
    }

    private final void markRoots(ProtoType protoType) {
        if (this.pruningRules.isRoot(protoType)) {
            this.marks.root(protoType);
            this.queue.add(protoType);
            return;
        }
        for (Object reachable : this.reachableObjects(protoType)) {
            if (!(reachable instanceof ProtoMember) || !this.isRetainedVersion((ProtoMember)reachable) || !this.pruningRules.isRoot((ProtoMember)reachable)) continue;
            this.marks.root((ProtoMember)reachable);
            this.marks.mark(((ProtoMember)reachable).getType());
            this.queue.add(reachable);
        }
    }

    private final boolean isRetainedVersion(ProtoMember protoMember) {
        boolean bl;
        String member = protoMember.getMember();
        Type type = this.schema.getType(protoMember.getType());
        if (type instanceof MessageType) {
            Field field = ((MessageType)type).field(member);
            if (field == null && (field = ((MessageType)type).extensionField(member)) == null) {
                Intrinsics.throwNpe();
            }
            Field field2 = field;
            bl = this.pruningRules.isFieldRetainedVersion(field2.getOptions());
        } else if (type instanceof EnumType) {
            EnumConstant enumConstant = ((EnumType)type).constant(member);
            if (enumConstant == null) {
                Intrinsics.throwNpe();
            }
            EnumConstant enumConstant2 = enumConstant;
            bl = this.pruningRules.isEnumConstantRetainedVersion(enumConstant2.getOptions());
        } else {
            bl = true;
        }
        return bl;
    }

    private final void markReachable() {
        block6: {
            Object reachable;
            block0: while (true) {
                Object root;
                if (this.queue.poll() == null) {
                    break block6;
                }
                List<Object> reachableMembers = this.reachableObjects(root);
                Iterator<Object> iterator = reachableMembers.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    reachable = iterator.next();
                    Object object = reachable;
                    if (object instanceof ProtoType) {
                        if (root instanceof ProtoMember) {
                            if (!this.marks.mark((ProtoType)reachable, (ProtoMember)root)) continue;
                            this.queue.add(reachable);
                            continue;
                        }
                        if (!this.marks.mark((ProtoType)reachable)) continue;
                        this.queue.add(reachable);
                        continue;
                    }
                    if (object instanceof ProtoMember) {
                        if (!this.isRetainedVersion((ProtoMember)reachable) || !this.marks.mark((ProtoMember)reachable)) continue;
                        this.queue.add(reachable);
                        continue;
                    }
                    if (object != null) break block0;
                }
                break;
            }
            throw (Throwable)new IllegalStateException("unexpected object: " + reachable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Object> reachableObjects(Object root) {
        boolean bl = false;
        List result = new ArrayList();
        Options options = null;
        Options fileOptions = null;
        Object object = root;
        if (object instanceof ProtoMember) {
            String member = ((ProtoMember)root).getMember();
            Type type = this.schema.getType(((ProtoMember)root).getType());
            Service service = this.schema.getService(((ProtoMember)root).getType());
            if (type instanceof MessageType) {
                Field field = ((MessageType)type).field(member);
                if (field == null) {
                    field = ((MessageType)type).extensionField(member);
                }
                Field field2 = field;
                boolean bl2 = false;
                boolean bl3 = false;
                if (field2 == null) {
                    boolean bl4 = false;
                    String string = "unexpected member: " + member;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                result.add(field2.getType());
                options = field2.getOptions();
            } else if (type instanceof EnumType) {
                EnumConstant enumConstant = ((EnumType)type).constant(member);
                if (enumConstant == null) {
                    throw (Throwable)new IllegalStateException("unexpected member: " + member);
                }
                EnumConstant constant = enumConstant;
                options = constant.getOptions();
            } else {
                if (service == null) throw (Throwable)new IllegalStateException("unexpected member: " + member);
                Rpc rpc = service.rpc(member);
                if (rpc == null) {
                    throw (Throwable)new IllegalStateException("unexpected rpc: " + member);
                }
                Rpc rpc2 = rpc;
                result.add(rpc2.getRequestType());
                result.add(rpc2.getResponseType());
                options = rpc2.getOptions();
            }
        } else {
            if (!(object instanceof ProtoType)) throw (Throwable)new IllegalStateException("unexpected root: " + root);
            if (((ProtoType)root).isMap()) {
                result.add(((ProtoType)root).getKeyType());
                result.add(((ProtoType)root).getValueType());
                return result;
            }
            if (((ProtoType)root).isScalar()) {
                return result;
            }
            Type type = this.schema.getType((ProtoType)root);
            Service service = this.schema.getService((ProtoType)root);
            ProtoFile protoFile = this.schema.protoFile((ProtoType)root);
            if (protoFile == null) {
                Intrinsics.throwNpe();
            }
            fileOptions = protoFile.getOptions();
            if (type instanceof MessageType) {
                options = type.getOptions();
                for (Field field : ((MessageType)type).getDeclaredFields()) {
                    result.add(ProtoMember.Companion.get((ProtoType)root, field.getName()));
                }
                for (Field field : ((MessageType)type).getExtensionFields()) {
                    result.add(ProtoMember.Companion.get((ProtoType)root, field.getQualifiedName()));
                }
                for (OneOf oneOf : ((MessageType)type).getOneOfs()) {
                    for (Field field : oneOf.getFields()) {
                        result.add(ProtoMember.Companion.get((ProtoType)root, field.getName()));
                    }
                }
            } else if (type instanceof EnumType) {
                options = type.getOptions();
                for (EnumConstant constant : ((EnumType)type).getConstants()) {
                    result.add(ProtoMember.Companion.get(type.getType(), constant.getName()));
                }
            } else if (type instanceof EnclosingType) {
                options = type.getOptions();
            } else {
                if (service == null) throw (Throwable)new IllegalStateException("unexpected type: " + root);
                options = service.options();
                for (Rpc rpc : service.rpcs()) {
                    result.add(ProtoMember.Companion.get(service.type(), rpc.getName()));
                }
            }
        }
        Collection collection = options.fields(this.pruningRules).values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"options.fields(pruningRules).values()");
        this.addOptions(collection, result);
        if (fileOptions == null) return result;
        Collection collection2 = fileOptions.fields(this.pruningRules).values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"fileOptions.fields(pruningRules).values()");
        this.addOptions(collection2, result);
        return result;
    }

    private final void addOptions(Collection<ProtoMember> options, List<Object> result) {
        for (ProtoMember member : options) {
            if (!this.schema.isExtensionField(member)) {
                result.add(member.getType());
            }
            result.add(member);
        }
    }

    public Pruner(@NotNull Schema schema, @NotNull PruningRules pruningRules) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)pruningRules, (String)"pruningRules");
        this.schema = schema;
        this.pruningRules = pruningRules;
        this.marks = new MarkSet(this.pruningRules);
        this.queue = UtilJVMKt.mutableQueueOf();
    }
}

