/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.common.query;

import com.strategicgains.restexpress.common.query.FilterCallback;
import com.strategicgains.restexpress.common.query.FilterComponent;
import com.strategicgains.restexpress.common.query.FilterOperator;
import java.util.ArrayList;
import java.util.List;

public class QueryFilter {
    private List<FilterComponent> filters;

    public QueryFilter() {
    }

    public QueryFilter(List<FilterComponent> filters) {
        this();
        this.filters = new ArrayList<FilterComponent>(filters);
    }

    public QueryFilter addCriteria(String name, FilterOperator operator, Object value) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterComponent>();
        }
        this.filters.add(new FilterComponent(name, operator, value));
        return this;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public void iterate(FilterCallback callback) {
        if (callback == null || !this.hasFilters()) {
            return;
        }
        for (FilterComponent filterComponent : this.filters) {
            callback.filterOn(filterComponent);
        }
    }
}

