/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.common.query;

import com.strategicgains.restexpress.common.query.OrderCallback;
import com.strategicgains.restexpress.common.query.OrderComponent;
import java.util.ArrayList;
import java.util.List;

public class QueryOrder {
    private List<OrderComponent> sorts = null;

    public QueryOrder() {
    }

    public QueryOrder(String ... strings) {
        this();
        if (strings == null || strings.length == 0) {
            return;
        }
        this.addSort(strings);
    }

    public QueryOrder addSort(String ... strings) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<OrderComponent>(strings.length);
        }
        for (String sortString : strings) {
            boolean isDescending = sortString.startsWith("-");
            String fieldName = sortString.replaceAll("^[+-]{1}", "");
            this.sorts.add(new OrderComponent(fieldName, isDescending));
        }
        return this;
    }

    public boolean isSorted() {
        return this.sorts != null && !this.sorts.isEmpty();
    }

    public void iterate(OrderCallback callback) {
        if (callback == null || !this.isSorted()) {
            return;
        }
        for (OrderComponent component : this.sorts) {
            callback.orderBy(component);
        }
    }
}

