/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.common.query;

public class QueryRange
implements Cloneable {
    private Long offset = null;
    private Integer limit = null;

    public QueryRange() {
    }

    public QueryRange(QueryRange that) {
        this.offset = that.offset;
        this.limit = that.limit;
    }

    public QueryRange(long offset, int limit) {
        this.setOffset(offset);
        this.setLimit(limit);
    }

    public long getEnd() {
        return this.hasLimit() ? this.getOffset() + (long)this.getLimit() - 1L : this.getOffset();
    }

    public int getLimit() {
        return this.hasLimit() ? this.limit : 0;
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public void setLimit(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.limit = value;
    }

    public void setLimitViaEnd(long value) {
        if (!this.hasOffset()) {
            throw new IllegalArgumentException("Setting 'end' requires 'offset' to be set first");
        }
        this.setLimit((int)(value - this.getOffset() + 1L));
    }

    public long getStart() {
        return this.getOffset();
    }

    public void setStart(long value) {
        this.setOffset(value);
    }

    public long getOffset() {
        return this.hasOffset() ? this.offset.intValue() : 0;
    }

    public boolean hasOffset() {
        return this.offset != null;
    }

    public void setOffset(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        this.offset = value;
    }

    public boolean isInitialized() {
        return this.hasLimit() && this.hasOffset();
    }

    public boolean isValid() {
        return this.isInitialized() && this.getOffset() >= 0L && this.getLimit() >= 0;
    }

    public String toString() {
        return this.assembleString().toString();
    }

    public String asContentRange(long maxItems) {
        return this.assembleString().append("/").append(maxItems).toString();
    }

    private StringBuffer assembleString() {
        return new StringBuffer("items ").append(this.getOffset()).append("-").append(this.getEnd());
    }

    public boolean isOutside(int size, long count) {
        return size == 0 && count > 0L;
    }

    public boolean extendsBeyond(int size, long count) {
        return count == 0L && this.getEnd() > 0L || size > 0 && this.getEnd() > count - 1L;
    }

    public boolean spans(int size, long count) {
        return (long)size == count && count > 0L;
    }

    public boolean isInside(int size, long count) {
        return size > 0 && this.getEnd() < count && !this.spans(size, count);
    }

    public QueryRange clone() {
        try {
            return (QueryRange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return new QueryRange(this);
        }
    }
}

