/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.domain;

import java.util.UUID;
import org.restexpress.Response;
import org.restexpress.exception.ExceptionUtils;
import org.restexpress.exception.ServiceException;

public class ErrorResult {
    private String errorId;
    private int httpStatus;
    private String message;
    private String errorType;

    public ErrorResult(UUID errorId, int httpResponseCode, String errorMessage, String errorType) {
        this.errorId = errorId == null ? null : errorId.toString();
        this.httpStatus = httpResponseCode;
        this.message = errorMessage;
        this.errorType = errorType;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public static ErrorResult fromResponse(Response response) {
        return ErrorResult.fromResponse(response, true);
    }

    public static ErrorResult fromResponse(Response response, boolean includeCause) {
        if (response.hasException()) {
            Throwable exception = response.getException();
            Throwable rootCause = ExceptionUtils.findRootCause(exception);
            String message = rootCause != null ? rootCause.getMessage() : exception.getMessage();
            String causeName = null;
            if (includeCause) {
                String string = causeName = rootCause != null ? rootCause.getClass().getSimpleName() : exception.getClass().getSimpleName();
            }
            if (ServiceException.isAssignableFrom(exception)) {
                return new ErrorResult(((ServiceException)exception).getId(), response.getResponseStatus().code(), message, causeName);
            }
            return new ErrorResult(UUID.randomUUID(), response.getResponseStatus().code(), message, causeName);
        }
        return new ErrorResult(UUID.randomUUID(), response.getResponseStatus().code(), null, null);
    }
}

