/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.domain.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.restexpress.domain.metadata.UriMetadata;

public class RouteMetadata {
    private String name;
    private UriMetadata uri;
    private List<String> aliases;
    private List<String> supportedFormats;
    private String defaultFormat;
    private List<String> methods = new ArrayList<String>();
    private boolean isSerialized;
    private String baseUrl;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UriMetadata getUri() {
        return this.uri;
    }

    public void setUri(UriMetadata uri) {
        this.uri = uri;
    }

    public List<String> getSupportedFormats() {
        return this.supportedFormats == null ? Collections.EMPTY_LIST : this.supportedFormats;
    }

    public void addSupportedFormat(String format) {
        if (this.supportedFormats == null) {
            this.supportedFormats = new ArrayList<String>();
        }
        if (!this.getSupportedFormats().contains(format)) {
            this.supportedFormats.add(format);
        }
    }

    public void addAllSupportedFormats(Collection<String> formats) {
        for (String format : formats) {
            this.addSupportedFormat(format);
        }
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public List<String> getMethods() {
        return this.methods == null ? Collections.EMPTY_LIST : this.methods;
    }

    public void addMethod(String method) {
        if (!this.methods.contains(method)) {
            this.methods.add(method);
        }
    }

    public void addAllMethods(Collection<String> methods) {
        for (String method : methods) {
            this.addMethod(method);
        }
    }

    public boolean isSerialized() {
        return this.isSerialized;
    }

    public void setSerialized(boolean isSerialized) {
        this.isSerialized = isSerialized;
    }

    public List<String> getAliases() {
        return this.aliases == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.aliases);
    }

    public void addAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
        }
    }

    public void addAllAliases(List<String> aliases) {
        for (String alias : aliases) {
            this.addAlias(alias);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

