/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.domain.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.restexpress.domain.metadata.RouteMetadata;

public class ServerMetadata {
    private String name = null;
    private int port;
    private List<String> supportedFormats = null;
    private String defaultFormat = null;
    private List<RouteMetadata> routes = new ArrayList<RouteMetadata>();

    public ServerMetadata copyRootData() {
        ServerMetadata copy = new ServerMetadata();
        copy.setName(this.getName());
        copy.setPort(this.getPort());
        copy.setDefaultFormat(this.getDefaultFormat());
        copy.addAllSupportedFormats(this.getSupportedFormats());
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    public void addSupportedFormat(String format) {
        if (this.supportedFormats == null) {
            this.supportedFormats = new ArrayList<String>();
        }
        if (!this.supportedFormats.contains(format)) {
            this.supportedFormats.add(format);
        }
    }

    public void addAllSupportedFormats(Collection<String> formats) {
        for (String format : formats) {
            this.addSupportedFormat(format);
        }
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public List<RouteMetadata> getRoutes() {
        return this.routes;
    }

    public void addRoute(RouteMetadata route) {
        this.routes.add(route);
    }

    public void addAllRoutes(Collection<RouteMetadata> routes) {
        for (RouteMetadata route : routes) {
            this.addRoute(route);
        }
    }
}

