/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.domain.result;

import org.restexpress.Response;
import org.restexpress.domain.result.ErrorResult;
import org.restexpress.domain.result.FailResult;
import org.restexpress.domain.result.Result;
import org.restexpress.domain.result.SuccessResult;
import org.restexpress.exception.ServiceException;

public class ResultFactory {
    public Result fromResponse(Response response) {
        Integer httpResponseCode = response.getResponseStatus().code();
        if (!response.hasException()) {
            return new SuccessResult(httpResponseCode, response.getBody());
        }
        Throwable exception = response.getException();
        if (ServiceException.isAssignableFrom(exception)) {
            return new ErrorResult(httpResponseCode, (ServiceException)exception);
        }
        return new FailResult(httpResponseCode, exception);
    }
}

