/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.exception;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.restexpress.Response;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1810995969641082808L;
    private static final HttpResponseStatus STATUS = HttpResponseStatus.INTERNAL_SERVER_ERROR;
    private UUID id;
    private HttpResponseStatus httpStatus;
    private Map<String, String> headers;

    public ServiceException() {
        this((String)null);
    }

    public ServiceException(HttpResponseStatus status) {
        this(status, (String)null);
    }

    public ServiceException(String message) {
        this(STATUS, message);
    }

    public ServiceException(HttpResponseStatus status, String message) {
        super(message);
        this.initialize(status);
    }

    public ServiceException(Throwable cause) {
        this(STATUS, cause);
    }

    public ServiceException(HttpResponseStatus status, Throwable cause) {
        super(cause);
        this.initialize(status);
    }

    public ServiceException(String message, Throwable cause) {
        this(STATUS, message, cause);
    }

    public ServiceException(HttpResponseStatus status, String message, Throwable cause) {
        super(message, cause);
        this.initialize(status);
    }

    public HttpResponseStatus getHttpStatus() {
        return this.httpStatus;
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return String.format("%s (%s): %s, %s", this.getClass().getSimpleName(), this.getId().toString(), this.getHttpStatus().toString(), this.getLocalizedMessage());
    }

    public void augmentResponse(Response response) {
        if (this.hasHeaders()) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                response.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public String getHeader(String name) {
        return this.headers == null ? null : this.headers.get(name);
    }

    private void initialize(HttpResponseStatus status) {
        this.setHttpStatus(status);
        this.initializeId();
    }

    private void setHttpStatus(HttpResponseStatus status) {
        this.httpStatus = status;
    }

    private void initializeId() {
        this.id = UUID.randomUUID();
    }

    public static boolean isAssignableFrom(Throwable exception) {
        return ServiceException.class.isAssignableFrom(exception.getClass());
    }
}

