/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restexpress.Request;
import org.restexpress.common.query.FilterComponent;
import org.restexpress.common.query.FilterOperator;
import org.restexpress.common.query.QueryFilter;
import org.restexpress.common.util.StringUtils;
import org.restexpress.exception.BadRequestException;

public abstract class QueryFilters {
    private static final String FILTER_REGEX = "(.+?):(.*?):(.+?)";
    private static final Pattern FILTER_PATTERN = Pattern.compile("(.+?):(.*?):(.+?)");
    private static final String FILTER_HEADER_NAME = "filter";
    private static final String FILTER_SEPARATOR = "\\|";

    public static QueryFilter parseFrom(Request request) {
        return QueryFilters.parseFrom(request, (List<String>)null);
    }

    public static QueryFilter parseFrom(Request request, String ... allowedProperties) {
        return QueryFilters.parseFrom(request, Arrays.asList(allowedProperties));
    }

    public static QueryFilter parseFrom(Request request, List<String> allowedProperties) {
        String filterString = request.getHeader(FILTER_HEADER_NAME);
        if (filterString == null || filterString.trim().isEmpty()) {
            return new QueryFilter();
        }
        String[] nameValues = filterString.split(FILTER_SEPARATOR);
        if (nameValues == null || nameValues.length == 0) {
            return new QueryFilter();
        }
        ArrayList<FilterComponent> filters = new ArrayList<FilterComponent>(nameValues.length);
        for (String nameValue : nameValues) {
            Matcher m = FILTER_PATTERN.matcher(nameValue);
            if (!m.matches()) continue;
            String field = m.group(1);
            QueryFilters.enforceSupportedProperties(allowedProperties, field);
            FilterOperator operator = QueryFilters.findOperator(m.group(2));
            filters.add(new FilterComponent(field, operator, QueryFilters.parse(operator, m.group(3))));
        }
        return new QueryFilter(filters);
    }

    private static Object parse(FilterOperator operator, String group) {
        if (group == null || group.trim().isEmpty()) {
            return null;
        }
        if (FilterOperator.IN.equals((Object)operator)) {
            return group.split(",");
        }
        return group;
    }

    private static FilterOperator findOperator(String operation) {
        if (operation == null || "".equals(operation)) {
            return FilterOperator.CONTAINS;
        }
        String operator = operation.trim().toLowerCase();
        if ("=".equals(operator)) {
            return FilterOperator.EQUALS;
        }
        if ("!=".equals(operator)) {
            return FilterOperator.NOT_EQUALS;
        }
        if ("<".equals(operator)) {
            return FilterOperator.LESS_THAN;
        }
        if ("<=".equals(operator)) {
            return FilterOperator.LESS_THAN_OR_EQUAL_TO;
        }
        if (">".equals(operator)) {
            return FilterOperator.GREATER_THAN;
        }
        if (">=".equals(operator)) {
            return FilterOperator.GREATER_THAN_OR_EQUAL_TO;
        }
        if ("*".equals(operator)) {
            return FilterOperator.STARTS_WITH;
        }
        if ("in".equalsIgnoreCase(operator)) {
            return FilterOperator.IN;
        }
        return FilterOperator.EQUALS;
    }

    private static void enforceSupportedProperties(List<String> allowedProperties, String requested) {
        if (allowedProperties != null && !allowedProperties.contains(requested)) {
            throw new BadRequestException(requested + " is not a supported filter. Supported filter names are: " + StringUtils.join((String)", ", allowedProperties));
        }
    }
}

