/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route;

import java.util.ArrayList;
import java.util.List;
import org.restexpress.domain.metadata.RouteMetadata;
import org.restexpress.exception.NoRoutesDefinedException;
import org.restexpress.route.Route;
import org.restexpress.route.RouteBuilder;
import org.restexpress.route.RouteMapping;
import org.restexpress.route.parameterized.ParameterizedRouteBuilder;
import org.restexpress.route.regex.RegexRouteBuilder;
import org.restexpress.settings.RouteDefaults;
import org.restexpress.util.Callback;

public class RouteDeclaration {
    private List<RouteBuilder> routeBuilders;
    List<RouteMetadata> routeMetadata = new ArrayList<RouteMetadata>();

    public RouteDeclaration() {
        this.routeBuilders = new ArrayList<RouteBuilder>();
    }

    public ParameterizedRouteBuilder uri(String uri, Object controller, RouteDefaults defaults) {
        ParameterizedRouteBuilder builder = new ParameterizedRouteBuilder(uri, controller, defaults);
        this.routeBuilders.add(builder);
        return builder;
    }

    public RegexRouteBuilder regex(String regex, Object controller, RouteDefaults defaults) {
        RegexRouteBuilder builder = new RegexRouteBuilder(regex, controller, defaults);
        this.routeBuilders.add(builder);
        return builder;
    }

    public RouteMapping createRouteMapping(RouteDefaults defaults) {
        if (this.routeBuilders.isEmpty()) {
            throw new NoRoutesDefinedException("No routes defined for server");
        }
        final RouteMapping results = new RouteMapping();
        this.iterateRouteBuilders(new Callback<RouteBuilder>(){

            @Override
            public void process(RouteBuilder builder) {
                RouteDeclaration.this.routeMetadata.add(builder.asMetadata());
                for (Route route : builder.build()) {
                    results.addRoute(route);
                }
            }
        });
        return results;
    }

    public void iterateRouteBuilders(Callback<RouteBuilder> callback) {
        for (RouteBuilder builder : this.routeBuilders) {
            callback.process(builder);
        }
    }

    public List<RouteMetadata> getMetadata() {
        return this.routeMetadata;
    }
}

