/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.common.exception.ConfigurationException;
import org.restexpress.common.util.StringUtils;
import org.restexpress.contenttype.MediaRange;
import org.restexpress.contenttype.MediaTypeParser;
import org.restexpress.exception.BadRequestException;
import org.restexpress.exception.NotAcceptableException;
import org.restexpress.response.ResponseProcessor;
import org.restexpress.response.ResponseWrapper;
import org.restexpress.serialization.Aliasable;
import org.restexpress.serialization.SerializationProcessor;
import org.restexpress.serialization.SerializationProvider;
import org.restexpress.serialization.SerializationSettings;

public abstract class AbstractSerializationProvider
implements SerializationProvider {
    private Map<String, ResponseProcessor> processorsByFormat = new HashMap<String, ResponseProcessor>();
    private Map<String, ResponseProcessor> processorsByMediaType = new HashMap<String, ResponseProcessor>();
    private List<MediaRange> supportedMediaRanges = new ArrayList<MediaRange>();
    private ResponseProcessor defaultProcessor;
    private List<Alias> aliases = new ArrayList<Alias>();

    @Override
    public void add(SerializationProcessor processor, ResponseWrapper wrapper) {
        this.add(processor, wrapper, false);
    }

    @Override
    public void add(SerializationProcessor processor, ResponseWrapper wrapper, boolean isDefault) {
        this.addMediaRanges(processor.getSupportedMediaRanges());
        ResponseProcessor responseProcessor = new ResponseProcessor(processor, wrapper);
        this.assignAliases(responseProcessor);
        for (String format : processor.getSupportedFormats()) {
            if (this.processorsByFormat.containsKey(format)) {
                throw new ConfigurationException("Duplicate supported format: " + format);
            }
            this.processorsByFormat.put(format, responseProcessor);
        }
        for (MediaRange mediaRange : processor.getSupportedMediaRanges()) {
            String mediaType = mediaRange.asMediaType();
            if (this.processorsByMediaType.containsKey(mediaType)) continue;
            this.processorsByMediaType.put(mediaRange.asMediaType(), responseProcessor);
        }
        if (isDefault) {
            this.defaultProcessor = responseProcessor;
        }
    }

    @Override
    public void alias(String name, Class<?> type) {
        Alias a = new Alias(name, type);
        if (!this.aliases.contains(a)) {
            this.aliases.add(a);
        }
        this.assignAlias(a);
    }

    @Override
    public void setDefaultFormat(String format) {
        ResponseProcessor processor = this.processorsByFormat.get(format);
        if (processor == null) {
            throw new RuntimeException("No serialization processor found for requested response format: " + format);
        }
        this.defaultProcessor = processor;
    }

    public SerializationProcessor getSerializer(String format) {
        ResponseProcessor p = this.processorsByFormat.get(format);
        if (p != null) {
            return p.getSerializer();
        }
        return null;
    }

    @Override
    public SerializationSettings resolveRequest(Request request) {
        List<MediaRange> requestedMediaRanges;
        ResponseProcessor processor = null;
        String format = request.getFormat();
        String bestMatch = null;
        if (format != null && (processor = this.processorsByFormat.get(format)) == null) {
            throw new NotAcceptableException(format);
        }
        if (processor == null && (bestMatch = MediaTypeParser.getBestMatch(this.supportedMediaRanges, requestedMediaRanges = MediaTypeParser.parse(request.getHeader("Content-Type")))) != null) {
            processor = this.processorsByMediaType.get(bestMatch);
        }
        if (processor == null) {
            processor = this.defaultProcessor;
        }
        return new SerializationSettings(bestMatch == null ? request.getHeader("Content-Type") : bestMatch, processor);
    }

    @Override
    public SerializationSettings resolveResponse(Request request, Response response, boolean shouldForce) {
        String bestMatch = null;
        ResponseProcessor processor = null;
        String format = request.getFormat();
        if (this.exceptionOccurredBeforeRouteResolution(format, response)) {
            format = this.parseFormatFromUrl(request.getUrl());
        }
        if (format != null) {
            processor = this.processorsByFormat.get(format);
            if (processor != null) {
                bestMatch = processor.getSupportedMediaRanges().get(0).asMediaType();
            } else if (!shouldForce) {
                throw new BadRequestException("Requested representation format not supported: " + format + ". Supported formats: " + StringUtils.join((String)", ", this.processorsByFormat.keySet()));
            }
        }
        if (processor == null) {
            List<MediaRange> requestedMediaRanges = MediaTypeParser.parse(request.getHeader("Accept"));
            bestMatch = MediaTypeParser.getBestMatch(this.supportedMediaRanges, requestedMediaRanges);
            if (bestMatch != null) {
                processor = this.processorsByMediaType.get(bestMatch);
            } else if (!shouldForce && !requestedMediaRanges.isEmpty()) {
                throw new NotAcceptableException("Supported Media Types: " + StringUtils.join((String)", ", this.supportedMediaRanges));
            }
        }
        if (processor == null) {
            processor = this.defaultProcessor;
            bestMatch = processor.getSupportedMediaRanges().get(0).asMediaType();
        }
        return new SerializationSettings(bestMatch, processor);
    }

    private void addMediaRanges(List<MediaRange> mediaRanges) {
        if (mediaRanges == null) {
            return;
        }
        for (MediaRange mediaRange : mediaRanges) {
            if (this.supportedMediaRanges.contains(mediaRange)) continue;
            this.supportedMediaRanges.add(mediaRange);
        }
    }

    private void assignAlias(Alias a) {
        for (ResponseProcessor processor : this.processorsByFormat.values()) {
            if (!Aliasable.class.isAssignableFrom(processor.getSerializer().getClass())) continue;
            ((Aliasable)((Object)processor.getSerializer())).alias(a.name, a.type);
        }
    }

    private void assignAliases(ResponseProcessor processor) {
        if (Aliasable.class.isAssignableFrom(processor.getClass())) {
            Aliasable p = (Aliasable)((Object)processor);
            for (Alias a : this.aliases) {
                p.alias(a.name, a.type);
            }
        }
    }

    private boolean exceptionOccurredBeforeRouteResolution(String format, Response response) {
        return format == null && response.hasException();
    }

    private String parseFormatFromUrl(String url) {
        int queryDelimiterIndex = url.indexOf(63);
        String path = queryDelimiterIndex > 0 ? url.substring(0, queryDelimiterIndex) : url;
        int formatDelimiterIndex = path.lastIndexOf(46);
        return formatDelimiterIndex > 0 ? path.substring(formatDelimiterIndex + 1) : null;
    }

    private static class Alias {
        private String name;
        private Class<?> type;

        public Alias(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(that.getClass())) {
                return this.equals((Alias)that);
            }
            return false;
        }

        public boolean equals(Alias that) {
            if (that == null) {
                return false;
            }
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        public int hashCode() {
            return this.getClass().hashCode() + this.name.hashCode() + this.type.hashCode();
        }
    }
}

